/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.deserializers.string;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.NottableString;

public class NottableStringDeserializer
extends JsonDeserializer<NottableString> {
    @Override
    public NottableString deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            Boolean not = null;
            String string = null;
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jp.getCurrentName();
                if ("not".equals(fieldName)) {
                    jp.nextToken();
                    not = jp.getBooleanValue();
                    continue;
                }
                if (!"value".equals(fieldName)) continue;
                jp.nextToken();
                string = jp.readValueAs(String.class);
            }
            if (StringUtils.isEmpty(string)) {
                return null;
            }
            return NottableString.string(string, not);
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_STRING) {
            return NottableString.deserializeNottableString(jp.readValueAs(String.class));
        }
        return null;
    }
}

