/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import org.mockserver.client.serialization.model.BodyWithContentTypeDTO;
import org.mockserver.client.serialization.model.ConnectionOptionsDTO;
import org.mockserver.client.serialization.model.DTO;
import org.mockserver.client.serialization.model.DelayDTO;
import org.mockserver.model.Cookies;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class HttpResponseDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<HttpResponse> {
    private Integer statusCode;
    private BodyWithContentTypeDTO body;
    private Cookies cookies = new Cookies();
    private Headers headers = new Headers();
    private DelayDTO delay;
    private ConnectionOptionsDTO connectionOptions;

    public HttpResponseDTO(HttpResponse httpResponse) {
        if (httpResponse != null) {
            this.statusCode = httpResponse.getStatusCode();
            this.body = BodyWithContentTypeDTO.createDTO(httpResponse.getBody());
            this.headers = httpResponse.getHeaders();
            this.cookies = httpResponse.getCookies();
            this.delay = httpResponse.getDelay() != null ? new DelayDTO(httpResponse.getDelay()) : null;
            this.connectionOptions = httpResponse.getConnectionOptions() != null ? new ConnectionOptionsDTO(httpResponse.getConnectionOptions()) : null;
        }
    }

    public HttpResponseDTO() {
    }

    @Override
    public HttpResponse buildObject() {
        return new HttpResponse().withStatusCode(this.statusCode).withBody(this.body != null ? this.body.buildObject() : null).withHeaders(this.headers).withCookies(this.cookies).withDelay(this.delay != null ? this.delay.buildObject() : null).withConnectionOptions(this.connectionOptions != null ? this.connectionOptions.buildObject() : null);
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public HttpResponseDTO setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public BodyWithContentTypeDTO getBody() {
        return this.body;
    }

    public HttpResponseDTO setBody(BodyWithContentTypeDTO body) {
        this.body = body;
        return this;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public HttpResponseDTO setHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public HttpResponseDTO setCookies(Cookies cookies) {
        this.cookies = cookies;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public HttpResponseDTO setDelay(DelayDTO delay) {
        this.delay = delay;
        return this;
    }

    public ConnectionOptionsDTO getConnectionOptions() {
        return this.connectionOptions;
    }

    public HttpResponseDTO setConnectionOptions(ConnectionOptionsDTO connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }
}

