/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.mockserver.client.serialization.model.BodyWithContentTypeDTO;
import org.mockserver.client.serialization.model.ParameterDTO;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;

public class ParameterBodyDTO
extends BodyWithContentTypeDTO {
    private List<ParameterDTO> parameters;

    public ParameterBodyDTO(ParameterBody parameterBody) {
        this(parameterBody, (Boolean)false);
    }

    public ParameterBodyDTO(ParameterBody parameterBody, Boolean not) {
        super(parameterBody.getType(), not, parameterBody.getContentType());
        this.parameters = Lists.transform(parameterBody.getValue(), new Function<Parameter, ParameterDTO>(){

            @Override
            public ParameterDTO apply(Parameter parameter) {
                return new ParameterDTO(parameter);
            }
        });
    }

    protected ParameterBodyDTO() {
    }

    public List<ParameterDTO> getParameters() {
        return this.parameters;
    }

    @Override
    public ParameterBody buildObject() {
        return new ParameterBody(Lists.transform(this.parameters, new Function<ParameterDTO, Parameter>(){

            @Override
            public Parameter apply(ParameterDTO parameterDTO) {
                return parameterDTO.buildObject();
            }
        }));
    }
}

