/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTypeMapper {
    public static final Charset DEFAULT_HTTP_CHARACTER_SET = CharsetUtil.ISO_8859_1;
    private static final Logger logger = LoggerFactory.getLogger(ContentTypeMapper.class);
    private static final Set<String> UTF_8_CONTENT_TYPES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("application/atom+xml")).add("application/ecmascript")).add("application/javascript")).add("application/json")).add("application/jsonml+json")).add("application/lost+xml")).add("application/wsdl+xml")).add("application/xaml+xml")).add("application/xhtml+xml")).add("application/xml")).add("application/xml-dtd")).add("application/xop+xml")).add("application/xslt+xml")).add("application/xspf+xml")).add("application/x-www-form-urlencoded")).add("image/svg+xml")).add("text/css")).add("text/csv")).add("text/html")).add("text/plain")).add("text/richtext")).add("text/sgml")).add("text/tab-separated-values")).add("text/x-fortran")).add("text/x-java-source")).build();

    public static boolean isBinary(String contentTypeHeader) {
        boolean binary = false;
        if (!Strings.isNullOrEmpty(contentTypeHeader)) {
            boolean utf8Body;
            String contentType = contentTypeHeader.toLowerCase();
            boolean bl = utf8Body = contentType.contains("utf-8") || contentType.contains("utf8") || contentType.contains("text") || contentType.contains("javascript") || contentType.contains("json") || contentType.contains("ecmascript") || contentType.contains("css") || contentType.contains("csv") || contentType.contains("html") || contentType.contains("xhtml") || contentType.contains("form") || contentType.contains("urlencoded") || contentType.contains("xml");
            if (!utf8Body) {
                binary = contentType.contains("ogg") || contentType.contains("audio") || contentType.contains("video") || contentType.contains("image") || contentType.contains("pdf") || contentType.contains("postscript") || contentType.contains("font") || contentType.contains("woff") || contentType.contains("model") || contentType.contains("zip") || contentType.contains("gzip") || contentType.contains("nacl") || contentType.contains("pnacl") || contentType.contains("vnd") || contentType.contains("application");
            }
        }
        return binary;
    }

    public static Charset getCharsetFromContentTypeHeader(String contentType) {
        Charset charset = DEFAULT_HTTP_CHARACTER_SET;
        if (contentType != null) {
            String charsetName = StringUtils.substringAfterLast(contentType, HttpHeaderValues.CHARSET.toString() + '=');
            if (!Strings.isNullOrEmpty(charsetName)) {
                try {
                    charset = Charset.forName(charsetName);
                }
                catch (UnsupportedCharsetException uce) {
                    logger.info("Unsupported character set {} in Content-Type header: {}.", (Object)StringUtils.substringAfterLast(contentType, HttpHeaderValues.CHARSET.toString() + 61), (Object)contentType);
                }
                catch (IllegalCharsetNameException icne) {
                    logger.info("Illegal character set {} in Content-Type header: {}.", (Object)StringUtils.substringAfterLast(contentType, HttpHeaderValues.CHARSET.toString() + 61), (Object)contentType);
                }
            } else if (UTF_8_CONTENT_TYPES.contains(contentType)) {
                charset = CharsetUtil.UTF_8;
            }
        }
        return charset;
    }
}

