/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.model.BinaryBodyDTO;
import org.mockserver.client.serialization.model.BodyDTO;
import org.mockserver.client.serialization.model.JsonBodyDTO;
import org.mockserver.client.serialization.model.JsonSchemaBodyDTO;
import org.mockserver.client.serialization.model.ParameterBodyDTO;
import org.mockserver.client.serialization.model.RegexBodyDTO;
import org.mockserver.client.serialization.model.StringBodyDTO;
import org.mockserver.client.serialization.model.XPathBodyDTO;
import org.mockserver.client.serialization.model.XmlBodyDTO;
import org.mockserver.client.serialization.model.XmlSchemaBodyDTO;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.matchers.BinaryMatcher;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.BooleanMatcher;
import org.mockserver.matchers.ExactStringMatcher;
import org.mockserver.matchers.HashMapMatcher;
import org.mockserver.matchers.JsonSchemaMatcher;
import org.mockserver.matchers.JsonStringMatcher;
import org.mockserver.matchers.Matcher;
import org.mockserver.matchers.MultiValueMapMatcher;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.matchers.ParameterStringMatcher;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.matchers.XPathStringMatcher;
import org.mockserver.matchers.XmlSchemaMatcher;
import org.mockserver.matchers.XmlStringMatcher;
import org.mockserver.mock.Expectation;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Cookies;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.Parameters;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlBody;
import org.mockserver.model.XmlSchemaBody;

public class HttpRequestMatcher
extends NotMatcher<HttpRequest> {
    private LoggingFormatter logFormatter;
    private Expectation expectation;
    private HttpRequest httpRequest;
    private RegexStringMatcher methodMatcher = null;
    private RegexStringMatcher pathMatcher = null;
    private MultiValueMapMatcher queryStringParameterMatcher = null;
    private BodyMatcher bodyMatcher = null;
    private MultiValueMapMatcher headerMatcher = null;
    private HashMapMatcher cookieMatcher = null;
    private BooleanMatcher keepAliveMatcher = null;
    private BodyDTO bodyDTOMatcher = null;
    private BooleanMatcher sslMatcher = null;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    public HttpRequestMatcher(HttpRequest httpRequest, LoggingFormatter logFormatter) {
        this.httpRequest = httpRequest;
        this.logFormatter = logFormatter;
        if (httpRequest != null) {
            this.withMethod(httpRequest.getMethod());
            this.withPath(httpRequest.getPath());
            this.withQueryStringParameters(httpRequest.getQueryStringParameters());
            this.withBody(httpRequest.getBody());
            this.withHeaders(httpRequest.getHeaders());
            this.withCookies(httpRequest.getCookies());
            this.withKeepAlive(httpRequest.isKeepAlive());
            this.withSsl(httpRequest.isSecure());
        }
        this.addFieldsExcludedFromEqualsAndHashCode("logFormatter", "objectMapper");
    }

    public HttpRequestMatcher(Expectation expectation, LoggingFormatter logFormatter) {
        this.expectation = expectation;
        this.httpRequest = expectation.getHttpRequest();
        this.logFormatter = logFormatter;
        if (this.httpRequest != null) {
            this.withMethod(this.httpRequest.getMethod());
            this.withPath(this.httpRequest.getPath());
            this.withQueryStringParameters(this.httpRequest.getQueryStringParameters());
            this.withBody(this.httpRequest.getBody());
            this.withHeaders(this.httpRequest.getHeaders());
            this.withCookies(this.httpRequest.getCookies());
            this.withKeepAlive(this.httpRequest.isKeepAlive());
            this.withSsl(this.httpRequest.isSecure());
        }
        this.addFieldsExcludedFromEqualsAndHashCode("logFormatter", "objectMapper");
    }

    public Expectation getExpectation() {
        return this.expectation;
    }

    private void withMethod(NottableString method) {
        this.methodMatcher = new RegexStringMatcher(method);
    }

    private void withPath(NottableString path) {
        this.pathMatcher = new RegexStringMatcher(path);
    }

    private void withQueryStringParameters(Parameters parameters) {
        this.queryStringParameterMatcher = new MultiValueMapMatcher(parameters.toCaseInsensitiveRegexMultiMap());
    }

    private void withBody(Body body) {
        if (body != null) {
            switch (body.getType()) {
                case STRING: {
                    StringBody stringBody = (StringBody)body;
                    this.bodyDTOMatcher = new StringBodyDTO(stringBody);
                    this.bodyMatcher = new ExactStringMatcher(NottableString.string(stringBody.getValue(), stringBody.getNot()));
                    break;
                }
                case REGEX: {
                    RegexBody regexBody = (RegexBody)body;
                    this.bodyDTOMatcher = new RegexBodyDTO(regexBody);
                    this.bodyMatcher = new RegexStringMatcher(NottableString.string(regexBody.getValue(), regexBody.getNot()));
                    break;
                }
                case PARAMETERS: {
                    ParameterBody parameterBody = (ParameterBody)body;
                    this.bodyDTOMatcher = new ParameterBodyDTO(parameterBody);
                    this.bodyMatcher = new ParameterStringMatcher((List<Parameter>)parameterBody.getValue());
                    break;
                }
                case XPATH: {
                    XPathBody xPathBody = (XPathBody)body;
                    this.bodyDTOMatcher = new XPathBodyDTO(xPathBody);
                    this.bodyMatcher = new XPathStringMatcher(xPathBody.getValue());
                    break;
                }
                case XML: {
                    XmlBody xmlBody = (XmlBody)body;
                    this.bodyDTOMatcher = new XmlBodyDTO(xmlBody);
                    this.bodyMatcher = new XmlStringMatcher(xmlBody.getValue());
                    break;
                }
                case JSON: {
                    JsonBody jsonBody = (JsonBody)body;
                    this.bodyDTOMatcher = new JsonBodyDTO(jsonBody);
                    this.bodyMatcher = new JsonStringMatcher(jsonBody.getValue(), jsonBody.getMatchType());
                    break;
                }
                case JSON_SCHEMA: {
                    JsonSchemaBody jsonSchemaBody = (JsonSchemaBody)body;
                    this.bodyDTOMatcher = new JsonSchemaBodyDTO(jsonSchemaBody);
                    this.bodyMatcher = new JsonSchemaMatcher(jsonSchemaBody.getValue());
                    break;
                }
                case XML_SCHEMA: {
                    XmlSchemaBody xmlSchemaBody = (XmlSchemaBody)body;
                    this.bodyDTOMatcher = new XmlSchemaBodyDTO(xmlSchemaBody);
                    this.bodyMatcher = new XmlSchemaMatcher(xmlSchemaBody.getValue());
                    break;
                }
                case BINARY: {
                    BinaryBody binaryBody = (BinaryBody)body;
                    this.bodyDTOMatcher = new BinaryBodyDTO(binaryBody);
                    this.bodyMatcher = new BinaryMatcher(binaryBody.getValue());
                }
            }
            if (body.isNot()) {
                this.bodyMatcher = HttpRequestMatcher.not(this.bodyMatcher);
            }
        }
    }

    private void withHeaders(Headers headers) {
        this.headerMatcher = new MultiValueMapMatcher(headers.toCaseInsensitiveRegexMultiMap());
    }

    private void withCookies(Cookies cookies) {
        this.cookieMatcher = new HashMapMatcher(cookies.toCaseInsensitiveRegexMultiMap());
    }

    private void withKeepAlive(Boolean keepAlive) {
        this.keepAliveMatcher = new BooleanMatcher(keepAlive);
    }

    private void withSsl(Boolean isSsl) {
        this.sslMatcher = new BooleanMatcher(isSsl);
    }

    @Override
    public boolean matches(HttpRequest request) {
        return this.matches(request, true);
    }

    public boolean matches(HttpRequest request, boolean logMatchResults) {
        boolean matches = false;
        if (this.isActive()) {
            if (request == this.httpRequest) {
                matches = true;
            } else if (this.httpRequest == null) {
                matches = true;
            } else if (request != null) {
                boolean totalResultAfterNotOperatorApplied;
                boolean methodMatches = Strings.isNullOrEmpty(request.getMethod().getValue()) || this.matches(this.methodMatcher, request.getMethod());
                boolean pathMatches = Strings.isNullOrEmpty(request.getPath().getValue()) || this.matches(this.pathMatcher, request.getPath());
                boolean queryStringParametersMatches = this.matches(this.queryStringParameterMatcher, request.getQueryStringParameterList() != null ? new ArrayList<Parameter>(request.getQueryStringParameterList()) : null);
                String bodyAsString = request.getBody() != null ? new String(request.getBody().getRawBytes(), request.getBody().getCharset(Charsets.UTF_8)) : "";
                BodyDTO bodyDTO = null;
                try {
                    bodyDTO = this.objectMapper.readValue(bodyAsString, BodyDTO.class);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                boolean bodyMatches = bodyDTO == null || this.bodyDTOMatcher == null || bodyDTO.getType() == Body.Type.STRING ? (this.bodyMatcher instanceof BinaryMatcher ? this.matches(this.bodyMatcher, request.getBodyAsRawBytes()) : (this.bodyMatcher instanceof ExactStringMatcher || this.bodyMatcher instanceof RegexStringMatcher || this.bodyMatcher instanceof XmlStringMatcher ? this.matches(this.bodyMatcher, NottableString.string(bodyAsString)) : this.matches(this.bodyMatcher, bodyAsString))) : this.bodyDTOMatcher.equals(bodyDTO);
                boolean headersMatch = this.matches(this.headerMatcher, request.getHeaderList() != null ? new ArrayList<Header>(request.getHeaderList()) : null);
                boolean cookiesMatch = this.matches(this.cookieMatcher, request.getCookieList() != null ? new ArrayList<Cookie>(request.getCookieList()) : null);
                boolean keepAliveMatches = this.matches(this.keepAliveMatcher, request.isKeepAlive());
                boolean sslMatches = this.matches(this.sslMatcher, request.isSecure());
                boolean totalResult = methodMatches && pathMatches && queryStringParametersMatches && bodyMatches && headersMatch && cookiesMatch && keepAliveMatches && sslMatches;
                boolean bl = totalResultAfterNotOperatorApplied = request.isNot() == (this.httpRequest.isNot() == (this.not != totalResult));
                if (logMatchResults) {
                    if (!totalResultAfterNotOperatorApplied) {
                        StringBuilder becauseBuilder = new StringBuilder();
                        becauseBuilder.append("method matches = ").append(methodMatches);
                        becauseBuilder.append(Character.NEW_LINE).append("path matches = ").append(pathMatches);
                        becauseBuilder.append(Character.NEW_LINE).append("query string parameters match = ").append(queryStringParametersMatches);
                        becauseBuilder.append(Character.NEW_LINE).append("body matches = ").append(bodyMatches);
                        becauseBuilder.append(Character.NEW_LINE).append("headers match = ").append(headersMatch);
                        becauseBuilder.append(Character.NEW_LINE).append("cookies match = ").append(cookiesMatch);
                        becauseBuilder.append(Character.NEW_LINE).append("keep-alive matches = ").append(keepAliveMatches);
                        becauseBuilder.append(Character.NEW_LINE).append("ssl matches = ").append(sslMatches);
                        if (request.isNot()) {
                            becauseBuilder.append(Character.NEW_LINE).append("request 'not' operator is enabled");
                        }
                        if (this.httpRequest.isNot()) {
                            becauseBuilder.append(Character.NEW_LINE).append("expectation's request 'not' operator is enabled");
                        }
                        if (this.not) {
                            becauseBuilder.append(Character.NEW_LINE).append("expectation's request matcher 'not' operator is enabled");
                        }
                        this.logFormatter.infoLog(request, "request:{}" + Character.NEW_LINE + " did" + (totalResult ? "" : " not") + " match expectation:{}" + Character.NEW_LINE + " because:{}", request, this, becauseBuilder.toString());
                    } else {
                        this.logFormatter.infoLog(request, "request:{}" + Character.NEW_LINE + " matched expectation:{}", request, this);
                    }
                }
                matches = totalResultAfterNotOperatorApplied;
            }
        }
        return matches;
    }

    private <T> boolean matches(Matcher<T> matcher, T t) {
        boolean result = false;
        if (matcher == null) {
            result = true;
        } else if (matcher.matches(t)) {
            result = true;
        }
        return result;
    }

    public boolean isActive() {
        return this.expectation == null || this.expectation.isActive();
    }

    public Expectation decrementRemainingMatches() {
        return this.expectation.decrementRemainingMatches();
    }

    @Override
    public String toString() {
        try {
            return ObjectMapperFactory.createObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this.httpRequest);
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

