/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.model.Action;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.model.ObjectWithJsonToString;

public class Expectation
extends ObjectWithJsonToString {
    private final HttpRequest httpRequest;
    private final Times times;
    private final TimeToLive timeToLive;
    private HttpResponse httpResponse;
    private HttpTemplate httpResponseTemplate;
    private HttpForward httpForward;
    private HttpTemplate httpForwardTemplate;
    private HttpError httpError;
    private HttpClassCallback httpClassCallback;
    private HttpObjectCallback httpObjectCallback;

    public Expectation(HttpRequest httpRequest) {
        this(httpRequest, Times.unlimited(), TimeToLive.unlimited());
    }

    public Expectation(HttpRequest httpRequest, Times times, TimeToLive timeToLive) {
        this.httpRequest = httpRequest;
        this.times = times;
        this.timeToLive = timeToLive;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public HttpTemplate getHttpResponseTemplate() {
        return this.httpResponseTemplate;
    }

    public HttpTemplate getHttpForwardTemplate() {
        return this.httpForwardTemplate;
    }

    public HttpForward getHttpForward() {
        return this.httpForward;
    }

    public HttpError getHttpError() {
        return this.httpError;
    }

    public HttpClassCallback getHttpClassCallback() {
        return this.httpClassCallback;
    }

    public HttpObjectCallback getHttpObjectCallback() {
        return this.httpObjectCallback;
    }

    public Action getAction() {
        if (this.httpResponse != null) {
            return this.getHttpResponse();
        }
        if (this.httpResponseTemplate != null) {
            return this.getHttpResponseTemplate();
        }
        if (this.httpForward != null) {
            return this.getHttpForward();
        }
        if (this.httpForwardTemplate != null) {
            return this.getHttpForwardTemplate();
        }
        if (this.httpError != null) {
            return this.getHttpError();
        }
        if (this.httpClassCallback != null) {
            return this.getHttpClassCallback();
        }
        if (this.httpObjectCallback != null) {
            return this.getHttpObjectCallback();
        }
        return null;
    }

    public Times getTimes() {
        return this.times;
    }

    public TimeToLive getTimeToLive() {
        return this.timeToLive;
    }

    public Expectation thenRespond(HttpResponse httpResponse) {
        if (httpResponse != null) {
            if (this.httpResponseTemplate != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a response template has been set");
            }
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a forward has been set");
            }
            if (this.httpForwardTemplate != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a forward template has been set");
            }
            if (this.httpError != null) {
                throw new IllegalArgumentException("It is not possible to set a response once an error has been set");
            }
            if (this.httpClassCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a class callback has been set");
            }
            if (this.httpObjectCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a response once an object callback has been set");
            }
            this.httpResponse = httpResponse;
        }
        return this;
    }

    public Expectation thenRespond(HttpTemplate httpTemplate) {
        if (httpTemplate != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set a response template once a response has been set");
            }
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set a response template once a forward has been set");
            }
            if (this.httpForwardTemplate != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a forward template has been set");
            }
            if (this.httpError != null) {
                throw new IllegalArgumentException("It is not possible to set a response template once an error has been set");
            }
            if (this.httpClassCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a response template once a class callback has been set");
            }
            if (this.httpObjectCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a response template once an object callback has been set");
            }
            httpTemplate.setActionType(Action.Type.RESPONSE_TEMPLATE);
            this.httpResponseTemplate = httpTemplate;
        }
        return this;
    }

    public Expectation thenForward(HttpForward httpForward) {
        if (httpForward != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once a response has been set");
            }
            if (this.httpResponseTemplate != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once a response template has been set");
            }
            if (this.httpForwardTemplate != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a forward template has been set");
            }
            if (this.httpError != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once an error has been set");
            }
            if (this.httpClassCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once a class callback has been set");
            }
            if (this.httpObjectCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once an object callback has been set");
            }
            this.httpForward = httpForward;
        }
        return this;
    }

    public Expectation thenForward(HttpTemplate httpTemplate) {
        if (httpTemplate != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once a response has been set");
            }
            if (this.httpResponseTemplate != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once a response template has been set");
            }
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a forward has been set");
            }
            if (this.httpError != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once an error has been set");
            }
            if (this.httpClassCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once a class callback has been set");
            }
            if (this.httpObjectCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once an object callback has been set");
            }
            httpTemplate.setActionType(Action.Type.FORWARD_TEMPLATE);
            this.httpForwardTemplate = httpTemplate;
        }
        return this;
    }

    public Expectation thenError(HttpError httpError) {
        if (httpError != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set an error once a response has been set");
            }
            if (this.httpResponseTemplate != null) {
                throw new IllegalArgumentException("It is not possible to set an error once a response template has been set");
            }
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set an error once a forward has been set");
            }
            if (this.httpForwardTemplate != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a forward template has been set");
            }
            if (this.httpClassCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a error once a class callback has been set");
            }
            if (this.httpObjectCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a error once an object callback has been set");
            }
            this.httpError = httpError;
        }
        return this;
    }

    public Expectation thenCallback(HttpClassCallback httpClassCallback) {
        if (httpClassCallback != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set a class callback once a response has been set");
            }
            if (this.httpResponseTemplate != null) {
                throw new IllegalArgumentException("It is not possible to set a class callback once a response template has been set");
            }
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set a class callback once a forward has been set");
            }
            if (this.httpForwardTemplate != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a forward template has been set");
            }
            if (this.httpError != null) {
                throw new IllegalArgumentException("It is not possible to set a class callback once an error has been set");
            }
            if (this.httpObjectCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a class callback once an object callback has been set");
            }
            this.httpClassCallback = httpClassCallback;
        }
        return this;
    }

    public Expectation thenCallback(HttpObjectCallback httpObjectCallback) {
        if (httpObjectCallback != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set an object callback once a response has been set");
            }
            if (this.httpResponseTemplate != null) {
                throw new IllegalArgumentException("It is not possible to set an object callback once a response template has been set");
            }
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set an object callback once a forward has been set");
            }
            if (this.httpForwardTemplate != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a forward template has been set");
            }
            if (this.httpError != null) {
                throw new IllegalArgumentException("It is not possible to set an object callback once an error has been set");
            }
            if (this.httpClassCallback != null) {
                throw new IllegalArgumentException("It is not possible to set an object callback once an class callback has been set");
            }
            this.httpObjectCallback = httpObjectCallback;
        }
        return this;
    }

    @JsonIgnore
    public boolean isActive() {
        return this.hasRemainingMatches() && this.isStillAlive();
    }

    private boolean hasRemainingMatches() {
        return this.times == null || this.times.greaterThenZero();
    }

    private boolean isStillAlive() {
        return this.timeToLive == null || this.timeToLive.stillAlive();
    }

    public Expectation decrementRemainingMatches() {
        if (this.times != null) {
            this.times.decrement();
        }
        return this;
    }

    public void setNotUnlimitedResponses() {
        if (this.times != null) {
            this.times.setNotUnlimitedResponses();
        }
    }

    public boolean contains(HttpRequest httpRequest) {
        return httpRequest != null && this.httpRequest.equals(httpRequest);
    }
}

