/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.client.serialization.java.ExpectationToJavaSerializer;
import org.mockserver.client.serialization.java.HttpRequestToJavaSerializer;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.filters.LogFilter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.model.Action;
import org.mockserver.model.ClearType;
import org.mockserver.model.Format;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RetrieveType;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.LoggerFactory;

public class HttpStateHandler {
    public static final String LOG_SEPARATOR = "------------------------------------\n";
    private LoggingFormatter logFormatter = new LoggingFormatter(LoggerFactory.getLogger(this.getClass()), this);
    private LogFilter logFilter = new LogFilter(this.logFormatter);
    private MockServerMatcher mockServerMatcher = new MockServerMatcher(this.logFormatter);
    private WebSocketClientRegistry webSocketClientRegistry = new WebSocketClientRegistry();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestToJavaSerializer httpRequestToJavaSerializer = new HttpRequestToJavaSerializer();
    private ExpectationToJavaSerializer expectationToJavaSerializer = new ExpectationToJavaSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    public LoggingFormatter getLogFormatter() {
        return this.logFormatter;
    }

    public void clear(HttpRequest request) {
        HttpRequest requestMatcher = null;
        if (!Strings.isNullOrEmpty(request.getBodyAsString())) {
            requestMatcher = this.httpRequestSerializer.deserialize(request.getBodyAsString());
        }
        try {
            ClearType retrieveType = ClearType.valueOf(StringUtils.defaultIfEmpty(request.getFirstQueryStringParameter("type").toUpperCase(), "ALL"));
            switch (retrieveType) {
                case LOG: {
                    this.logFilter.clear(requestMatcher);
                    this.logFormatter.infoLog(requestMatcher, "clearing request logs that match:{}", requestMatcher);
                    break;
                }
                case EXPECTATIONS: {
                    this.mockServerMatcher.clear(requestMatcher);
                    this.logFormatter.infoLog(requestMatcher, "clearing expectations that match:{}", requestMatcher);
                    break;
                }
                case ALL: {
                    this.logFilter.clear(requestMatcher);
                    this.mockServerMatcher.clear(requestMatcher);
                    this.logFormatter.infoLog(requestMatcher, "clearing expectations and request logs that match:{}", requestMatcher);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("type") + "\" is not a valid value for \"type\" parameter, only the following values are supported " + Lists.transform(Arrays.asList(ClearType.values()), new Function<ClearType, String>(){

                @Override
                public String apply(ClearType input) {
                    return input.name().toLowerCase();
                }
            }));
        }
    }

    public void reset() {
        this.mockServerMatcher.reset();
        this.logFilter.reset();
        this.logFormatter.infoLog(HttpRequest.request(), "resetting all expectations and request logs", new Object[0]);
    }

    public void add(Expectation ... expectations) {
        for (Expectation expectation : expectations) {
            KeyAndCertificateFactory.addSubjectAlternativeName(expectation.getHttpRequest().getFirstHeader(HttpHeaderNames.HOST.toString()));
            this.mockServerMatcher.add(expectation);
            this.logFormatter.infoLog(expectation.getHttpRequest(), "creating expectation:{}", expectation);
        }
    }

    public Expectation firstMatchingExpectation(HttpRequest request) {
        if (this.mockServerMatcher.httpRequestMatchers.isEmpty()) {
            this.logFormatter.infoLog(HttpRequest.request(), "no active expectations when receiving request:{}", request);
        }
        return this.mockServerMatcher.firstMatchingExpectation(request);
    }

    public void log(LogEntry logEntry) {
        this.logFilter.onRequest(logEntry);
    }

    public HttpResponse retrieve(HttpRequest request) {
        HttpRequest httpRequest = null;
        if (!Strings.isNullOrEmpty(request.getBodyAsString())) {
            httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
        }
        HttpResponse response = HttpResponse.response();
        try {
            Format format = Format.valueOf(StringUtils.defaultIfEmpty(request.getFirstQueryStringParameter("format").toUpperCase(), "JSON"));
            RetrieveType retrieveType = RetrieveType.valueOf(StringUtils.defaultIfEmpty(request.getFirstQueryStringParameter("type").toUpperCase(), "REQUESTS"));
            block1 : switch (retrieveType) {
                case LOGS: {
                    this.logFormatter.infoLog(httpRequest, "retrieving " + retrieveType.name().toLowerCase() + " that match:{}", httpRequest == null ? HttpRequest.request() : httpRequest);
                    StringBuilder stringBuffer = new StringBuilder();
                    List<String> retrieveMessages = this.logFilter.retrieveMessages(httpRequest);
                    for (int i = 0; i < retrieveMessages.size(); ++i) {
                        stringBuffer.append(retrieveMessages.get(i));
                        if (i >= retrieveMessages.size() - 1) continue;
                        stringBuffer.append(LOG_SEPARATOR);
                    }
                    stringBuffer.append("\n");
                    response.withBody(stringBuffer.toString(), MediaType.PLAIN_TEXT_UTF_8);
                    break;
                }
                case REQUESTS: {
                    this.logFormatter.infoLog(httpRequest, "retrieving " + retrieveType.name().toLowerCase() + " in " + format.name().toLowerCase() + " that match:{}", httpRequest == null ? HttpRequest.request() : httpRequest);
                    List<HttpRequest> httpRequests = this.logFilter.retrieveRequests(httpRequest);
                    switch (format) {
                        case JAVA: {
                            response.withBody(this.httpRequestToJavaSerializer.serialize(httpRequests), MediaType.create("application", "java").withCharset(StandardCharsets.UTF_8));
                            break block1;
                        }
                        case JSON: {
                            response.withBody(this.httpRequestSerializer.serialize(httpRequests), MediaType.JSON_UTF_8);
                        }
                    }
                    break;
                }
                case RECORDED_EXPECTATIONS: {
                    this.logFormatter.infoLog(httpRequest, "retrieving " + retrieveType.name().toLowerCase() + " in " + format.name().toLowerCase() + " that match:{}", httpRequest == null ? HttpRequest.request() : httpRequest);
                    List<Expectation> expectations = this.logFilter.retrieveExpectations(httpRequest);
                    switch (format) {
                        case JAVA: {
                            response.withBody(this.expectationToJavaSerializer.serialize(expectations), MediaType.create("application", "java").withCharset(StandardCharsets.UTF_8));
                            break block1;
                        }
                        case JSON: {
                            response.withBody(this.expectationSerializer.serialize(expectations), MediaType.JSON_UTF_8);
                        }
                    }
                    break;
                }
                case ACTIVE_EXPECTATIONS: {
                    this.logFormatter.infoLog(httpRequest, "retrieving " + retrieveType.name().toLowerCase() + " in " + format.name().toLowerCase() + " that match:{}", httpRequest == null ? HttpRequest.request() : httpRequest);
                    List<Expectation> expectations = this.mockServerMatcher.retrieveExpectations(httpRequest);
                    switch (format) {
                        case JAVA: {
                            response.withBody(this.expectationToJavaSerializer.serialize(expectations), MediaType.create("application", "java").withCharset(StandardCharsets.UTF_8));
                            break block1;
                        }
                        case JSON: {
                            response.withBody(this.expectationSerializer.serialize(expectations), MediaType.JSON_UTF_8);
                        }
                    }
                    break;
                }
            }
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().contains(RetrieveType.class.getSimpleName())) {
                throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("type") + "\" is not a valid value for \"type\" parameter, only the following values are supported " + Lists.transform(Arrays.asList(RetrieveType.values()), new Function<RetrieveType, String>(){

                    @Override
                    public String apply(RetrieveType input) {
                        return input.name().toLowerCase();
                    }
                }));
            }
            throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("format") + "\" is not a valid value for \"format\" parameter, only the following values are supported " + Lists.transform(Arrays.asList(Format.values()), new Function<Format, String>(){

                @Override
                public String apply(Format input) {
                    return input.name().toLowerCase();
                }
            }));
        }
        return response.withStatusCode(200);
    }

    public String verify(Verification verification) {
        return this.logFilter.verify(verification);
    }

    public String verify(VerificationSequence verification) {
        return this.logFilter.verify(verification);
    }

    public boolean handle(HttpRequest request, ResponseWriter responseWriter, boolean warDeployment) {
        this.logFormatter.traceLog("received request:{}", request);
        if ((ConfigurationProperties.enableCORSForAPI() || ConfigurationProperties.enableCORSForAllResponses()) && request.getMethod().getValue().equals("OPTIONS") && !request.getFirstHeader("Origin").isEmpty()) {
            responseWriter.writeResponse(request, HttpResponseStatus.OK);
        } else if (request.matches("PUT", "/expectation")) {
            for (Expectation expectation : this.expectationSerializer.deserializeArray(request.getBodyAsString())) {
                if (warDeployment && !this.validateSupportedFeatures(expectation, request, responseWriter)) continue;
                this.add(expectation);
            }
            responseWriter.writeResponse(request, HttpResponseStatus.CREATED);
        } else if (request.matches("PUT", "/clear")) {
            this.clear(request);
            responseWriter.writeResponse(request, HttpResponseStatus.OK);
        } else if (request.matches("PUT", "/reset")) {
            this.reset();
            responseWriter.writeResponse(request, HttpResponseStatus.OK);
        } else if (request.matches("PUT", "/retrieve")) {
            responseWriter.writeResponse(request, this.retrieve(request));
        } else if (request.matches("PUT", "/verify")) {
            Verification verification = this.verificationSerializer.deserialize(request.getBodyAsString());
            String result = this.verify(verification);
            if (StringUtils.isEmpty(result)) {
                responseWriter.writeResponse(request, HttpResponseStatus.ACCEPTED);
            } else {
                responseWriter.writeResponse(request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create("text", "plain").toString());
            }
            this.logFormatter.infoLog(request, "verifying requests that match:{}", verification);
        } else if (request.matches("PUT", "/verifySequence")) {
            VerificationSequence verificationSequence = this.verificationSequenceSerializer.deserialize(request.getBodyAsString());
            String result = this.verify(verificationSequence);
            if (StringUtils.isEmpty(result)) {
                responseWriter.writeResponse(request, HttpResponseStatus.ACCEPTED);
            } else {
                responseWriter.writeResponse(request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create("text", "plain").toString());
            }
            this.logFormatter.infoLog(request, "verifying sequence that match:{}", verificationSequence);
        } else {
            return false;
        }
        return true;
    }

    private boolean validateSupportedFeatures(Expectation expectation, HttpRequest request, ResponseWriter responseWriter) {
        boolean valid = true;
        Action action = expectation.getAction();
        String NOT_SUPPORTED_MESSAGE = " is not supported by MockServer deployed as a WAR due to limitations in the JEE specification; use mockserver-netty to enable these features";
        if (action instanceof HttpResponse && ((HttpResponse)action).getConnectionOptions() != null) {
            responseWriter.writeResponse(request, HttpResponse.response("ConnectionOptions" + NOT_SUPPORTED_MESSAGE));
            valid = false;
        } else if (action instanceof HttpObjectCallback) {
            responseWriter.writeResponse(request, HttpResponse.response("HttpObjectCallback" + NOT_SUPPORTED_MESSAGE));
            valid = false;
        } else if (action instanceof HttpError) {
            responseWriter.writeResponse(request, HttpResponse.response("HttpError" + NOT_SUPPORTED_MESSAGE));
            valid = false;
        }
        return valid;
    }

    public WebSocketClientRegistry getWebSocketClientRegistry() {
        return this.webSocketClientRegistry;
    }
}

