/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mockserver.MockServer;
import org.mockserver.mockserver.MockServerHandler;
import org.mockserver.mockserver.callback.WebSocketServerHandler;
import org.mockserver.server.netty.codec.MockServerServerCodec;
import org.mockserver.server.unification.PortUnificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerInitializer
extends PortUnificationHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HttpStateHandler httpStateHandler = new HttpStateHandler();
    private final MockServer mockServer;

    MockServerInitializer(MockServer mockServer) {
        this.mockServer = mockServer;
    }

    @Override
    protected void configurePipeline(ChannelHandlerContext ctx, ChannelPipeline pipeline) {
        if (this.logger.isDebugEnabled()) {
            pipeline.addLast(new LoggingHandler(this.logger));
        }
        boolean isSecure = false;
        if (ctx.channel().attr(PortUnificationHandler.SSL_ENABLED).get() != null) {
            isSecure = ctx.channel().attr(PortUnificationHandler.SSL_ENABLED).get();
        }
        pipeline.addLast(new WebSocketServerHandler(this.httpStateHandler.getWebSocketClientRegistry()));
        pipeline.addLast(new MockServerServerCodec(isSecure));
        pipeline.addLast(new MockServerHandler(this.mockServer, this.httpStateHandler));
    }
}

