/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mockserver.model.Action;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Cookie;
import org.mockserver.model.Cookies;
import org.mockserver.model.Delay;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.NottableString;
import org.mockserver.model.StringBody;

public class HttpResponse
extends Action {
    private Integer statusCode;
    private BodyWithContentType body;
    private Headers headers = new Headers();
    private Cookies cookies = new Cookies();
    private Delay delay;
    private ConnectionOptions connectionOptions;

    public static HttpResponse response() {
        return new HttpResponse();
    }

    public static HttpResponse response(String body) {
        return new HttpResponse().withStatusCode(200).withBody(body);
    }

    public static HttpResponse notFoundResponse() {
        return new HttpResponse().withStatusCode(404);
    }

    public HttpResponse withStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public HttpResponse withBody(String body) {
        if (body != null) {
            this.body = new StringBody(body);
        }
        return this;
    }

    public HttpResponse withBody(String body, Charset charset) {
        if (body != null) {
            this.body = new StringBody(body, charset);
        }
        return this;
    }

    public HttpResponse withBody(String body, MediaType contentType) {
        if (body != null) {
            this.body = new StringBody(body, contentType);
        }
        return this;
    }

    public HttpResponse withBody(byte[] body) {
        this.body = new BinaryBody(body);
        return this;
    }

    public HttpResponse withBody(BodyWithContentType body) {
        this.body = body;
        return this;
    }

    public BodyWithContentType getBody() {
        return this.body;
    }

    @JsonIgnore
    public String getBodyAsString() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public HttpResponse withHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public HttpResponse withHeaders(List<Header> headers) {
        this.headers.withEntries(headers);
        return this;
    }

    public HttpResponse withHeaders(Header ... headers) {
        this.headers.withEntries(headers);
        return this;
    }

    public HttpResponse withHeader(Header header) {
        this.headers.withEntry(header);
        return this;
    }

    public HttpResponse withHeader(String name, String ... values) {
        this.headers.withEntry(name, values);
        return this;
    }

    public HttpResponse replaceHeader(Header header) {
        this.headers.replaceEntry(header);
        return this;
    }

    public HttpResponse replaceHeader(String name, String ... values) {
        this.headers.replaceEntry(name, values);
        return this;
    }

    public List<Header> getHeaderList() {
        return this.headers.getEntries();
    }

    public List<String> getHeader(String name) {
        return this.headers.getValues(name);
    }

    public String getFirstHeader(String name) {
        return this.headers.getFirstValue(name);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsEntry(name);
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public HttpResponse withCookies(Cookies cookies) {
        this.cookies = cookies;
        return this;
    }

    public boolean containsHeader(String name, String value) {
        return this.headers.containsEntry(name, value);
    }

    public HttpResponse withCookies(List<Cookie> cookies) {
        this.cookies.withEntries(cookies);
        return this;
    }

    public HttpResponse withCookies(Cookie ... cookies) {
        this.cookies.withEntries(cookies);
        return this;
    }

    public HttpResponse withCookie(Cookie cookie) {
        this.cookies.withEntry(cookie);
        return this;
    }

    public HttpResponse withCookie(String name, String value) {
        this.cookies.withEntry(name, value);
        return this;
    }

    public HttpResponse withCookie(NottableString name, NottableString value) {
        this.cookies.withEntry(name, value);
        return this;
    }

    public List<Cookie> getCookieList() {
        return this.cookies.getEntries();
    }

    public HttpResponse withDelay(Delay delay) {
        this.delay = delay;
        return this;
    }

    public HttpResponse withDelay(TimeUnit timeUnit, long value) {
        this.delay = new Delay(timeUnit, value);
        return this;
    }

    public Delay getDelay() {
        return this.delay;
    }

    public HttpResponse withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonIgnore
    public HttpResponse applyDelay() {
        if (this.delay != null) {
            this.delay.applyDelay();
        }
        return this;
    }

    @Override
    @JsonIgnore
    public Action.Type getType() {
        return Action.Type.RESPONSE;
    }

    public HttpResponse clone() {
        return HttpResponse.response().withStatusCode(this.getStatusCode()).withBody(this.getBody()).withHeaders(this.getHeaders().clone()).withCookies(this.getCookies().clone()).withDelay(this.getDelay()).withConnectionOptions(this.getConnectionOptions());
    }
}

