/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.javascript;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.model.DTO;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.model.HttpRequest;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.model.HttpRequestTemplateObject;
import org.mockserver.templates.engine.serializer.HttpTemplateOutputDeserializer;

public class JavaScriptTemplateEngine
implements TemplateEngine {
    private static final ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
    private final LoggingFormatter logFormatter;
    private HttpTemplateOutputDeserializer httpTemplateOutputDeserializer;

    public JavaScriptTemplateEngine(LoggingFormatter logFormatter) {
        this.logFormatter = logFormatter;
        this.httpTemplateOutputDeserializer = new HttpTemplateOutputDeserializer(logFormatter);
    }

    @Override
    public <T> T executeTemplate(String template, HttpRequest request, Class<? extends DTO<T>> dtoClass) {
        T result = null;
        String script = "function handle(request) {" + StringFormatter.indentAndToString(template)[0] + "}";
        try {
            if (engine != null) {
                engine.eval(script + " function serialise(request) { return JSON.stringify(handle(JSON.parse(request)), null, 2); }");
                Object stringifiedResponse = ((Invocable)((Object)engine)).invokeFunction("serialise", new HttpRequestTemplateObject(request));
                this.logFormatter.infoLog(request, "Generated output:{}" + Character.NEW_LINE + " from template:{}" + Character.NEW_LINE + " for request:{}", stringifiedResponse, script, request);
                result = this.httpTemplateOutputDeserializer.deserializer(request, (String)stringifiedResponse, dtoClass);
            } else {
                this.logFormatter.errorLog(request, "JavaScript based templating is only available in a JVM with the \"nashorn\" JavaScript engine, please use a JVM with the \"nashorn\" JavaScript engine, such as Oracle Java 8+", new RuntimeException("\"nashorn\" JavaScript engine not available"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(StringFormatter.formatLogMessage("Exception transforming template:{}" + Character.NEW_LINE + " for request:{}", script, request), e);
        }
        return result;
    }
}

