/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.cli;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.configuration.IntegerStringListParser;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mockserver.MockServer;
import org.slf4j.event.Level;

public class Main {
    static final String USAGE = "   java -jar <path to mockserver-jetty-jar-with-dependencies.jar> -serverPort <port> [-proxyRemotePort <port>] [-proxyRemoteHost <hostname>] [-logLevel <level>] " + Character.NEW_LINE + "                                                                                                                                                                 " + Character.NEW_LINE + "     valid options are:                                                                                                                                          " + Character.NEW_LINE + "        -serverPort <port>           The HTTP, HTTPS, SOCKS and HTTP CONNECT                                                                                     " + Character.NEW_LINE + "                                     port(s) for both mocking and proxying                                                                                       " + Character.NEW_LINE + "                                     requests.  Port unification is used to                                                                                      " + Character.NEW_LINE + "                                     support all protocols for proxying and                                                                                      " + Character.NEW_LINE + "                                     mocking on the same port(s). Supports                                                                                       " + Character.NEW_LINE + "                                     comma separated list for binding to                                                                                         " + Character.NEW_LINE + "                                     multiple ports.                                                                                                             " + Character.NEW_LINE + "                                                                                                                                                                 " + Character.NEW_LINE + "        -proxyRemotePort <port>      Optionally enables port forwarding mode.                                                                                    " + Character.NEW_LINE + "                                     When specified all requests received will                                                                                   " + Character.NEW_LINE + "                                     be forwarded to the specified port, unless                                                                                  " + Character.NEW_LINE + "                                     they match an expectation.                                                                                                  " + Character.NEW_LINE + "                                                                                                                                                                 " + Character.NEW_LINE + "        -proxyRemoteHost <hostname>  Specified the host to forward all proxy                                                                                     " + Character.NEW_LINE + "                                     requests to when port forwarding mode has                                                                                   " + Character.NEW_LINE + "                                     been enabled using the proxyRemotePort                                                                                      " + Character.NEW_LINE + "                                     option.  This setting is ignored unless                                                                                     " + Character.NEW_LINE + "                                     proxyRemotePort has been specified. If no                                                                                   " + Character.NEW_LINE + "                                     value is provided for proxyRemoteHost when                                                                                  " + Character.NEW_LINE + "                                     proxyRemotePort has been specified,                                                                                         " + Character.NEW_LINE + "                                     proxyRemoteHost will default to \"localhost\".                                                                              " + Character.NEW_LINE + "                                                                                                                                                                 " + Character.NEW_LINE + "        -logLevel <level>            Optionally specify log level using SLF4J levels:                                                                            " + Character.NEW_LINE + "                                     TRACE, DEBUG, INFO, WARN, ERROR, OFF or Java                                                                                " + Character.NEW_LINE + "                                     Logger levels: FINEST, FINE, INFO, WARNING,                                                                                 " + Character.NEW_LINE + "                                     SEVERE or OFF. If not specified default is INFO                                                                             " + Character.NEW_LINE + "                                                                                                                                                                 " + Character.NEW_LINE + "   i.e. java -jar ./mockserver-jetty-jar-with-dependencies.jar -serverPort 1080 -proxyRemotePort 80 -proxyRemoteHost www.mock-server.com -logLevel WARN          " + Character.NEW_LINE + "                                                                                                                                                                 " + Character.NEW_LINE;
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(Main.class);
    private static final IntegerStringListParser INTEGER_STRING_LIST_PARSER = new IntegerStringListParser();
    static PrintStream systemOut = System.out;
    static boolean usageShown = false;

    public static void main(String ... arguments) {
        try {
            Map<String, String> parsedArguments = Main.parseArguments(arguments);
            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.DEBUG).setMessageFormat("Using command line options: {}").setArguments(Joiner.on(", ").withKeyValueSeparator("=").join(parsedArguments)));
            if (parsedArguments.size() > 0 && parsedArguments.containsKey(Arguments.serverPort.name())) {
                if (parsedArguments.containsKey(Arguments.logLevel.name())) {
                    ConfigurationProperties.logLevel(parsedArguments.get(Arguments.logLevel.name()));
                }
                Integer[] localPorts = INTEGER_STRING_LIST_PARSER.toArray(parsedArguments.get(Arguments.serverPort.name()));
                if (parsedArguments.containsKey(Arguments.proxyRemotePort.name())) {
                    String remoteHost = parsedArguments.get(Arguments.proxyRemoteHost.name());
                    if (StringUtils.isBlank(remoteHost)) {
                        remoteHost = "localhost";
                    }
                    new MockServer((Integer)Integer.parseInt(parsedArguments.get(Arguments.proxyRemotePort.name())), remoteHost, localPorts);
                } else {
                    new MockServer(localPorts);
                }
                if (ConfigurationProperties.logLevel() != null) {
                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(ConfigurationProperties.logLevel()).setMessageFormat("Logger level is " + (Object)((Object)ConfigurationProperties.logLevel()) + ", change using:\n - 'ConfigurationProperties.logLevel(String level)' in Java code,\n - '-logLevel' command line argument,\n - 'mockserver.logLevel' JVM system property or,\n - 'mockserver.logLevel' property value in 'mockserver.properties'"));
                }
            } else {
                Main.showUsage();
            }
        }
        catch (Throwable throwable) {
            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.ERROR).setMessageFormat("Exception while starting: {}").setThrowable(throwable));
            Main.showUsage();
        }
    }

    private static Map<String, String> parseArguments(String ... arguments) {
        HashMap<String, String> parsedArguments = new HashMap<String, String>();
        ArrayList<String> errorMessages = new ArrayList<String>();
        Iterator<String> argumentsIterator = Arrays.asList(arguments).iterator();
        while (argumentsIterator.hasNext()) {
            String next = argumentsIterator.next();
            String argumentName = StringUtils.substringAfter(next, "-");
            if (argumentsIterator.hasNext()) {
                String argumentValue = argumentsIterator.next();
                if (!Arguments.names().containsIgnoreCase(argumentName)) {
                    Main.showUsage();
                    break;
                }
                String errorMessage = "";
                switch (Arguments.valueOf(argumentName)) {
                    case serverPort: {
                        if (argumentValue.matches("^\\d+(,\\d+)*$")) break;
                        errorMessage = argumentName + " value \"" + argumentValue + "\" is invalid, please specify a comma separated list of ports i.e. \"1080,1081,1082\"";
                        break;
                    }
                    case proxyRemotePort: {
                        if (argumentValue.matches("^\\d+$")) break;
                        errorMessage = argumentName + " value \"" + argumentValue + "\" is invalid, please specify a port i.e. \"1080\"";
                        break;
                    }
                    case proxyRemoteHost: {
                        String validIpAddressRegex = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
                        String validHostnameRegex = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$";
                        if (argumentValue.matches(validIpAddressRegex) || argumentValue.matches(validHostnameRegex)) break;
                        errorMessage = argumentName + " value \"" + argumentValue + "\" is invalid, please specify a host name i.e. \"localhost\" or \"127.0.0.1\"";
                        break;
                    }
                    case logLevel: {
                        if (Arrays.asList("TRACE", "DEBUG", "INFO", "WARN", "ERROR", "OFF", "FINEST", "FINE", "INFO", "WARNING", "SEVERE").contains(argumentValue)) break;
                        errorMessage = argumentName + " value \"" + argumentValue + "\" is invalid, please specify one of SL4J levels: \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\" or the Java Logger levels: \"FINEST\", \"FINE\", \"INFO\", \"WARNING\", \"SEVERE\", \"OFF\"";
                    }
                }
                if (errorMessage.isEmpty()) {
                    parsedArguments.put(argumentName, argumentValue);
                    continue;
                }
                errorMessages.add(errorMessage);
                continue;
            }
            Main.showUsage();
            break;
        }
        if (!errorMessages.isEmpty()) {
            Main.printValidationEror(errorMessages);
            throw new IllegalArgumentException(((Object)errorMessages).toString());
        }
        return parsedArguments;
    }

    private static void printValidationEror(List<String> errorMessages) {
        int maxLengthMessage = 0;
        for (String errorMessage : errorMessages) {
            if (errorMessage.length() <= maxLengthMessage) continue;
            maxLengthMessage = errorMessage.length();
        }
        systemOut.println(Character.NEW_LINE + "   " + Strings.padEnd("", maxLengthMessage, '='));
        for (String errorMessage : errorMessages) {
            systemOut.println("   " + errorMessage);
        }
        systemOut.println("   " + Strings.padEnd("", maxLengthMessage, '=') + Character.NEW_LINE);
    }

    private static void showUsage() {
        if (!usageShown) {
            usageShown = true;
            systemOut.print(USAGE);
        }
    }

    static class CaseInsensitiveList
    extends ArrayList<String> {
        CaseInsensitiveList() {
        }

        boolean containsIgnoreCase(String matcher) {
            for (String listItem : this) {
                if (!listItem.equalsIgnoreCase(matcher)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Arguments {
        serverPort,
        proxyRemotePort,
        proxyRemoteHost,
        logLevel;

        static final CaseInsensitiveList names;

        public static CaseInsensitiveList names() {
            return names;
        }

        static {
            names = new CaseInsensitiveList();
            for (Arguments arguments : Arguments.values()) {
                names.add(arguments.name());
            }
        }
    }
}

