/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.Future;
import org.mockserver.client.ClientException;
import org.mockserver.client.MockServerClient;
import org.mockserver.client.MockServerEventBus;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.action.ExpectationCallback;
import org.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.mock.action.ExpectationResponseCallback;
import org.mockserver.model.Delay;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpObject;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.websocket.WebSocketClient;
import org.mockserver.websocket.WebSocketException;

public class ForwardChainExpectation {
    private final MockServerLogger mockServerLogger;
    private final MockServerClient mockServerClient;
    private final Expectation expectation;
    private final MockServerEventBus mockServerEventBus;

    ForwardChainExpectation(MockServerLogger mockServerLogger, MockServerEventBus mockServerEventBus, MockServerClient mockServerClient, Expectation expectation) {
        this.mockServerLogger = mockServerLogger;
        this.mockServerEventBus = mockServerEventBus;
        this.mockServerClient = mockServerClient;
        this.expectation = expectation;
    }

    public void respond(HttpResponse httpResponse) {
        this.expectation.thenRespond(httpResponse);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void respond(HttpTemplate httpTemplate) {
        this.expectation.thenRespond(httpTemplate);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void respond(HttpClassCallback httpClassCallback) {
        this.expectation.thenRespond(httpClassCallback);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void respond(ExpectationResponseCallback expectationResponseCallback) {
        this.expectation.thenRespond(new HttpObjectCallback().withClientId(this.registerWebSocketClient(expectationResponseCallback, null)));
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void respond(ExpectationResponseCallback expectationResponseCallback, Delay delay) {
        this.expectation.thenRespond((HttpObjectCallback)new HttpObjectCallback().withClientId(this.registerWebSocketClient(expectationResponseCallback, null)).withDelay(delay));
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpForward httpForward) {
        this.expectation.thenForward(httpForward);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpTemplate httpTemplate) {
        this.expectation.thenForward(httpTemplate);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpClassCallback httpClassCallback) {
        this.expectation.thenForward(httpClassCallback);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(ExpectationForwardCallback expectationForwardCallback) {
        this.expectation.thenForward(new HttpObjectCallback().withClientId(this.registerWebSocketClient(expectationForwardCallback, null)));
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(ExpectationForwardCallback expectationForwardCallback, ExpectationForwardAndResponseCallback expectationForwardResponseCallback) {
        this.expectation.thenForward(new HttpObjectCallback().withResponseCallback(true).withClientId(this.registerWebSocketClient(expectationForwardCallback, expectationForwardResponseCallback)));
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(ExpectationForwardCallback expectationForwardCallback, Delay delay) {
        this.expectation.thenForward((HttpObjectCallback)new HttpObjectCallback().withClientId(this.registerWebSocketClient(expectationForwardCallback, null)).withDelay(delay));
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(ExpectationForwardCallback expectationForwardCallback, ExpectationForwardAndResponseCallback expectationForwardResponseCallback, Delay delay) {
        this.expectation.thenForward((HttpObjectCallback)new HttpObjectCallback().withResponseCallback(true).withClientId(this.registerWebSocketClient(expectationForwardCallback, expectationForwardResponseCallback)).withDelay(delay));
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpOverrideForwardedRequest httpOverrideForwardedRequest) {
        this.expectation.thenForward(httpOverrideForwardedRequest);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void error(HttpError httpError) {
        this.expectation.thenError(httpError);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    private <T extends HttpObject> String registerWebSocketClient(ExpectationCallback<T> expectationCallback, ExpectationForwardAndResponseCallback expectationForwardResponseCallback) {
        try {
            WebSocketClient<T> webSocketClient = new WebSocketClient<T>(new NioEventLoopGroup(2, new Scheduler.SchedulerThreadFactory(WebSocketClient.class.getSimpleName() + "-eventLoop")), this.mockServerLogger);
            Future<String> register = webSocketClient.registerExpectationCallback(expectationCallback, expectationForwardResponseCallback, this.mockServerClient.remoteAddress(), this.mockServerClient.contextPath(), this.mockServerClient.isSecure());
            this.mockServerEventBus.subscribe(webSocketClient::stopClient, MockServerEventBus.EventType.STOP, MockServerEventBus.EventType.RESET);
            return register.get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof WebSocketException) {
                throw new ClientException(e.getCause().getMessage(), e);
            }
            throw new ClientException("Unable to retrieve client registration id", e);
        }
    }

    @VisibleForTesting
    Expectation getExpectation() {
        return this.expectation;
    }
}

