/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.JsonBody;
import org.mockserver.model.MediaType;
import org.mockserver.model.StringBody;
import org.mockserver.model.XmlBody;
import org.mockserver.streams.IOStreamUtils;
import org.slf4j.event.Level;

public class BodyDecoderEncoder {
    private final MockServerLogger mockServerLogger;
    private final IOStreamUtils ioStreamUtils;

    public BodyDecoderEncoder(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.ioStreamUtils = new IOStreamUtils(mockServerLogger);
    }

    public ByteBuf bodyToByteBuf(Body body, String contentTypeHeader) {
        byte[] bytes = this.bodyToBytes(body, contentTypeHeader);
        if (bytes != null) {
            return Unpooled.copiedBuffer(bytes);
        }
        return Unpooled.buffer(0, 0);
    }

    public void bodyToServletResponse(HttpServletResponse httpServletResponse, Body body, String contentTypeHeader) {
        byte[] bytes = this.bodyToBytes(body, contentTypeHeader);
        if (bytes != null) {
            this.ioStreamUtils.writeToOutputStream(bytes, httpServletResponse);
        }
    }

    private byte[] bodyToBytes(Body body, String contentTypeHeader) {
        if (body != null) {
            if (body instanceof BinaryBody) {
                return body.getRawBytes();
            }
            if (body.getValue() instanceof String) {
                Charset responseCharset = MediaType.parse(contentTypeHeader).getCharsetOrDefault();
                Charset bodyCharset = body.getCharset(responseCharset);
                return ((String)body.getValue()).getBytes(bodyCharset);
            }
            return body.getRawBytes();
        }
        return null;
    }

    public BodyWithContentType byteBufToBody(ByteBuf content, String contentTypeHeader) {
        if (content != null && content.readableBytes() > 0) {
            byte[] bodyBytes = new byte[content.readableBytes()];
            content.readBytes(bodyBytes);
            return this.bytesToBody(bodyBytes, contentTypeHeader);
        }
        return null;
    }

    public BodyWithContentType servletRequestToBody(HttpServletRequest servletRequest) {
        if (servletRequest != null) {
            String contentTypeHeader = servletRequest.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
            try {
                byte[] bodyBytes = IOUtils.toByteArray(servletRequest.getInputStream());
                return this.bytesToBody(bodyBytes, contentTypeHeader);
            }
            catch (IOException ioe) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("IOException while reading HttpServletRequest input stream").setThrowable(ioe));
                throw new RuntimeException("IOException while reading HttpServletRequest input stream", ioe);
            }
        }
        return null;
    }

    private BodyWithContentType bytesToBody(byte[] bodyBytes, String contentTypeHeader) {
        if (bodyBytes.length > 0) {
            MediaType mediaType = MediaType.parse(contentTypeHeader);
            if (mediaType.isJson()) {
                return new JsonBody(new String(bodyBytes, mediaType.getCharsetOrDefault()), mediaType, JsonBody.DEFAULT_MATCH_TYPE);
            }
            if (mediaType.isXml()) {
                return new XmlBody(new String(bodyBytes, mediaType.getCharsetOrDefault()), mediaType);
            }
            if (mediaType.isString()) {
                return new StringBody(new String(bodyBytes, mediaType.getCharsetOrDefault()), bodyBytes, false, StringUtils.isNotBlank(contentTypeHeader) ? mediaType : null);
            }
            return new BinaryBody(bodyBytes, mediaType);
        }
        return null;
    }
}

