/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.codec.BodyDecoderEncoder;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NottableString;
import org.slf4j.event.Level;

public class MockServerToNettyResponseEncoder
extends MessageToMessageEncoder<HttpResponse> {
    private final MockServerLogger mockServerLogger;
    private final BodyDecoderEncoder bodyDecoderEncoder;

    public MockServerToNettyResponseEncoder(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.bodyDecoderEncoder = new BodyDecoderEncoder(mockServerLogger);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, HttpResponse response, List<Object> out) {
        out.add(this.encode(response));
    }

    public DefaultFullHttpResponse encode(HttpResponse httpResponse) {
        try {
            ByteBuf body = this.getBody(httpResponse);
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.getStatus(httpResponse), body);
            this.setHeaders(httpResponse, defaultFullHttpResponse, body);
            this.setCookies(httpResponse, defaultFullHttpResponse);
            return defaultFullHttpResponse;
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception encoding response {}").setArguments(httpResponse).setThrowable(throwable));
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.getStatus(httpResponse));
        }
    }

    private HttpResponseStatus getStatus(HttpResponse httpResponse) {
        int statusCode;
        int n = statusCode = httpResponse.getStatusCode() != null ? httpResponse.getStatusCode() : 200;
        if (!StringUtils.isEmpty(httpResponse.getReasonPhrase())) {
            return new HttpResponseStatus(statusCode, httpResponse.getReasonPhrase());
        }
        return HttpResponseStatus.valueOf(statusCode);
    }

    private ByteBuf getBody(HttpResponse httpResponse) {
        return this.bodyDecoderEncoder.bodyToByteBuf(httpResponse.getBody(), httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_TYPE.toString()));
    }

    private void setHeaders(HttpResponse httpResponse, DefaultFullHttpResponse response, ByteBuf body) {
        if (httpResponse.getHeaderMultimap() != null) {
            for (Map.Entry<NottableString, NottableString> header : httpResponse.getHeaderMultimap().entries()) {
                response.headers().add(header.getKey().getValue(), (Object)header.getValue().getValue());
            }
        }
        if (StringUtils.isBlank(httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_TYPE.toString())) && httpResponse.getBody() != null && httpResponse.getBody().getContentType() != null) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)httpResponse.getBody().getContentType());
        }
        if (StringUtils.isBlank(httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_LENGTH.toString()))) {
            boolean addContentLength;
            ConnectionOptions connectionOptions = httpResponse.getConnectionOptions();
            boolean overrideContentLength = connectionOptions != null && connectionOptions.getContentLengthHeaderOverride() != null;
            boolean bl = addContentLength = connectionOptions == null || ConnectionOptions.isFalseOrNull(connectionOptions.getSuppressContentLengthHeader());
            if (overrideContentLength) {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)connectionOptions.getContentLengthHeaderOverride());
            } else if (addContentLength) {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.readableBytes());
            }
        }
    }

    private void setCookies(HttpResponse httpResponse, DefaultFullHttpResponse response) {
        if (httpResponse.getCookieMap() != null) {
            for (Map.Entry<NottableString, NottableString> cookie : httpResponse.getCookieMap().entrySet()) {
                if (!httpResponse.cookieHeadeDoesNotAlreadyExists(cookie.getKey().getValue(), cookie.getValue().getValue())) continue;
                response.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.LAX.encode((Cookie)new DefaultCookie(cookie.getKey().getValue(), cookie.getValue().getValue())));
            }
        }
    }
}

