/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ThrowableSerializer
extends StdSerializer<Throwable> {
    public ThrowableSerializer() {
        super(Throwable.class);
    }

    @Override
    public void serialize(Throwable value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String stackTrace = ExceptionUtils.getStackTrace(value);
        String[] lines = stackTrace.split("\n");
        if (lines.length > 1) {
            gen.writeObject(lines);
        } else {
            gen.writeString(stackTrace);
        }
    }
}

