/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.log;

import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.mockserver.collections.BoundedConcurrentLinkedDeque;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.LogEventRequestAndResponse;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.serialization.HttpRequestSerializer;
import org.mockserver.ui.MockServerEventLogNotifier;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class MockServerEventLog
extends MockServerEventLogNotifier {
    private static final Logger logger = LoggerFactory.getLogger(MockServerEventLog.class);
    private static final Predicate<LogEntry> requestLogPredicate = input -> input.getType() == LogEntry.LogMessageType.RECEIVED_REQUEST;
    private static final Predicate<LogEntry> requestResponseLogPredicate = input -> input.getType() == LogEntry.LogMessageType.EXPECTATION_RESPONSE || input.getType() == LogEntry.LogMessageType.EXPECTATION_NOT_MATCHED_RESPONSE || input.getType() == LogEntry.LogMessageType.FORWARDED_REQUEST;
    private static final Predicate<LogEntry> recordedExpectationLogPredicate = input -> input.getType() == LogEntry.LogMessageType.FORWARDED_REQUEST;
    private static final Function<LogEntry, HttpRequest[]> logEntryToRequest = LogEntry::getHttpRequests;
    private static final Function<LogEntry, Expectation> logEntryToExpectation = LogEntry::getExpectation;
    private static final Function<LogEntry, LogEventRequestAndResponse> logEntryToHttpRequestAndHttpResponse = logEntry -> new LogEventRequestAndResponse().withHttpRequest(logEntry.getHttpRequest()).withHttpResponse(logEntry.getHttpResponse()).withTimestamp(logEntry.getTimestamp());
    private static final String[] EXCLUDED_FIELDS = new String[]{"key", "disruptor"};
    private MockServerLogger mockServerLogger;
    private Deque<LogEntry> eventLog = new BoundedConcurrentLinkedDeque<LogEntry>(ConfigurationProperties.maxLogEntries());
    private MatcherBuilder matcherBuilder;
    private HttpRequestSerializer httpRequestSerializer;
    private final boolean asynchronousEventProcessing;
    private Disruptor<LogEntry> disruptor;

    public MockServerEventLog(MockServerLogger mockServerLogger, Scheduler scheduler, boolean asynchronousEventProcessing) {
        super(scheduler);
        this.mockServerLogger = mockServerLogger;
        this.matcherBuilder = new MatcherBuilder(mockServerLogger);
        this.httpRequestSerializer = new HttpRequestSerializer(mockServerLogger);
        this.asynchronousEventProcessing = asynchronousEventProcessing;
        this.startRingBuffer();
    }

    public void add(LogEntry logEntry) {
        if (this.asynchronousEventProcessing) {
            if (!this.disruptor.getRingBuffer().tryPublishEvent(logEntry) && logEntry.getLogLevel().toInt() >= Level.WARN.toInt()) {
                logger.warn("Too many log events failed to add log event to ring buffer: " + logEntry);
            }
        } else {
            this.processLogEntry(logEntry);
        }
    }

    private void startRingBuffer() {
        this.disruptor = new Disruptor<LogEntry>(LogEntry::new, ConfigurationProperties.ringBufferSize(), new Scheduler.SchedulerThreadFactory("EventLog"));
        ExceptionHandler<LogEntry> errorHandler = new ExceptionHandler<LogEntry>(){

            @Override
            public void handleEventException(Throwable ex, long sequence, LogEntry logEntry) {
                logger.error("Exception handling log entry in log ring buffer, for log entry: " + logEntry, ex);
            }

            @Override
            public void handleOnStartException(Throwable ex) {
                logger.error("Exception starting log ring buffer", ex);
            }

            @Override
            public void handleOnShutdownException(Throwable ex) {
                logger.error("Exception during shutdown of log ring buffer", ex);
            }
        };
        this.disruptor.setDefaultExceptionHandler(errorHandler);
        this.disruptor.handleEventsWith((logEntry, sequence, endOfBatch) -> {
            if (logEntry.getType() != LogEntry.LogMessageType.RUNNABLE) {
                this.processLogEntry((LogEntry)logEntry);
            } else {
                logEntry.getConsumer().run();
            }
        });
        this.disruptor.start();
    }

    private void processLogEntry(LogEntry logEntry) {
        this.eventLog.add(logEntry);
        this.notifyListeners(this);
        MockServerLogger.writeToSystemOut(logger, logEntry);
    }

    public void stop() {
        try {
            this.disruptor.shutdown(2L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            MockServerLogger.writeToSystemOut(logger, new LogEntry().setLogLevel(Level.WARN).setMessageFormat("Exception while shutting down log ring buffer").setThrowable(throwable));
        }
    }

    public void reset() {
        CompletableFuture future = new CompletableFuture();
        this.disruptor.publishEvent(new LogEntry().setType(LogEntry.LogMessageType.RUNNABLE).setConsumer(() -> {
            this.eventLog.clear();
            future.complete("done");
            this.notifyListeners(this);
        }));
        try {
            future.get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
    }

    public void clear(HttpRequest httpRequest) {
        CompletableFuture future = new CompletableFuture();
        this.disruptor.publishEvent(new LogEntry().setType(LogEntry.LogMessageType.RUNNABLE).setConsumer(() -> {
            if (httpRequest != null) {
                HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
                for (LogEntry logEntry : new LinkedList<LogEntry>(this.eventLog)) {
                    HttpRequest[] requests = logEntry.getHttpRequests();
                    boolean matches = false;
                    if (requests != null) {
                        for (HttpRequest request : requests) {
                            if (!requestMatcher.matches(request)) continue;
                            matches = true;
                        }
                    } else {
                        matches = true;
                    }
                    if (!matches) continue;
                    this.eventLog.remove(logEntry);
                }
            } else {
                this.eventLog.clear();
            }
            future.complete("done");
            this.notifyListeners(this);
        }));
        try {
            future.get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
    }

    public void retrieveMessageLogEntries(HttpRequest httpRequest, Consumer<List<LogEntry>> listConsumer) {
        this.retrieveLogEntries(httpRequest, logEntry -> true, logEventStream -> listConsumer.accept(logEventStream.collect(Collectors.toList())));
    }

    public void retrieveRequestLogEntries(HttpRequest httpRequest, Consumer<List<LogEntry>> listConsumer) {
        this.retrieveLogEntries(httpRequest, requestLogPredicate, logEventStream -> listConsumer.accept(logEventStream.collect(Collectors.toList())));
    }

    public void retrieveRequests(HttpRequest httpRequest, Consumer<List<HttpRequest>> listConsumer) {
        this.retrieveLogEntries(httpRequest, requestLogPredicate, logEntryToRequest, logEventStream -> listConsumer.accept(logEventStream.flatMap(Arrays::stream).collect(Collectors.toList())));
    }

    public void retrieveRequestResponseMessageLogEntries(HttpRequest httpRequest, Consumer<List<LogEntry>> listConsumer) {
        this.retrieveLogEntries(httpRequest, requestResponseLogPredicate, logEventStream -> listConsumer.accept(logEventStream.collect(Collectors.toList())));
    }

    public void retrieveRequestResponses(HttpRequest httpRequest, Consumer<List<LogEventRequestAndResponse>> listConsumer) {
        this.retrieveLogEntries(httpRequest, requestResponseLogPredicate, logEntryToHttpRequestAndHttpResponse, logEventStream -> listConsumer.accept(logEventStream.collect(Collectors.toList())));
    }

    public void retrieveRecordedExpectationLogEntries(HttpRequest httpRequest, Consumer<List<LogEntry>> listConsumer) {
        this.retrieveLogEntries(httpRequest, recordedExpectationLogPredicate, logEventStream -> listConsumer.accept(logEventStream.collect(Collectors.toList())));
    }

    public void retrieveRecordedExpectations(HttpRequest httpRequest, Consumer<List<Expectation>> listConsumer) {
        this.retrieveLogEntries(httpRequest, recordedExpectationLogPredicate, logEntryToExpectation, logEventStream -> listConsumer.accept(logEventStream.collect(Collectors.toList())));
    }

    private void retrieveLogEntries(HttpRequest httpRequest, Predicate<LogEntry> logEntryPredicate, Consumer<Stream<LogEntry>> consumer) {
        this.disruptor.publishEvent(new LogEntry().setType(LogEntry.LogMessageType.RUNNABLE).setConsumer(() -> {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            consumer.accept(this.eventLog.stream().filter(logItem -> logItem.matches(httpRequestMatcher)).filter(logEntryPredicate));
        }));
    }

    private <T> void retrieveLogEntries(HttpRequest httpRequest, Predicate<LogEntry> logEntryPredicate, Function<LogEntry, T> logEntryMapper, Consumer<Stream<T>> consumer) {
        this.disruptor.publishEvent(new LogEntry().setType(LogEntry.LogMessageType.RUNNABLE).setConsumer(() -> {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            consumer.accept(this.eventLog.stream().filter(logItem -> logItem.matches(httpRequestMatcher)).filter(logEntryPredicate).map(logEntryMapper));
        }));
    }

    public <T> void retrieveLogEntriesInReverse(HttpRequest httpRequest, Predicate<LogEntry> logEntryPredicate, Function<LogEntry, T> logEntryMapper, Consumer<Stream<T>> consumer) {
        this.disruptor.publishEvent(new LogEntry().setType(LogEntry.LogMessageType.RUNNABLE).setConsumer(() -> {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            consumer.accept(StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.eventLog.descendingIterator(), 0), false).filter(logItem -> logItem.matches(httpRequestMatcher)).filter(logEntryPredicate).map(logEntryMapper));
        }));
    }

    public Future<String> verify(Verification verification) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.verify(verification, result::complete);
        return result;
    }

    public void verify(Verification verification, Consumer<String> resultConsumer) {
        if (verification != null) {
            this.retrieveRequests(verification.getHttpRequest(), httpRequests -> {
                if (!verification.getTimes().matches(httpRequests.size())) {
                    this.retrieveRequests(null, allRequests -> {
                        String serializedRequestToBeVerified = this.httpRequestSerializer.serialize(true, verification.getHttpRequest());
                        String serializedAllRequestInLog = allRequests.size() == 1 ? this.httpRequestSerializer.serialize(true, (HttpRequest)allRequests.get(0)) : this.httpRequestSerializer.serialize(true, (List<HttpRequest>)allRequests);
                        String failureMessage = "Request not found " + verification.getTimes() + ", expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
                        Object[] arguments = new Object[]{verification.getHttpRequest(), allRequests.size() == 1 ? allRequests.get(0) : allRequests};
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.VERIFICATION_FAILED).setLogLevel(Level.INFO).setHttpRequest(verification.getHttpRequest()).setMessageFormat("request not found " + verification.getTimes() + ", expected:{}but was:{}").setArguments(arguments));
                        resultConsumer.accept(failureMessage);
                    });
                } else {
                    resultConsumer.accept("");
                }
            });
        } else {
            resultConsumer.accept("");
        }
    }

    public Future<String> verify(VerificationSequence verification) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.verify(verification, result::complete);
        return result;
    }

    public void verify(VerificationSequence verificationSequence, Consumer<String> resultConsumer) {
        this.retrieveRequests(null, allRequests -> {
            String failureMessage = "";
            if (verificationSequence != null) {
                int requestLogCounter = 0;
                for (HttpRequest verificationHttpRequest : verificationSequence.getHttpRequests()) {
                    if (verificationHttpRequest == null) continue;
                    HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verificationHttpRequest);
                    boolean foundRequest = false;
                    while (!foundRequest && requestLogCounter < allRequests.size()) {
                        if (httpRequestMatcher.matches((HttpRequest)allRequests.get(requestLogCounter))) {
                            foundRequest = true;
                        }
                        ++requestLogCounter;
                    }
                    if (foundRequest) continue;
                    String serializedRequestToBeVerified = this.httpRequestSerializer.serialize(true, verificationSequence.getHttpRequests());
                    String serializedAllRequestInLog = allRequests.size() == 1 ? this.httpRequestSerializer.serialize(true, (HttpRequest)allRequests.get(0)) : this.httpRequestSerializer.serialize(true, (List<HttpRequest>)allRequests);
                    failureMessage = "Request sequence not found, expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
                    Object[] arguments = new Object[]{verificationSequence.getHttpRequests(), allRequests.size() == 1 ? allRequests.get(0) : allRequests};
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.VERIFICATION_FAILED).setLogLevel(Level.INFO).setHttpRequests(verificationSequence.getHttpRequests().toArray(new HttpRequest[0])).setMessageFormat("request sequence not found, expected:{}but was:{}").setArguments(arguments));
                    break;
                }
            }
            resultConsumer.accept(failureMessage);
        });
    }

    @Override
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

