/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import net.minidev.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.HttpRequest;
import org.slf4j.event.Level;

public class JsonPathMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"key", "mockServerLogger", "jsonPath"};
    private final MockServerLogger mockServerLogger;
    private final String matcher;
    private JsonPath jsonPath;

    JsonPathMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
        if (StringUtils.isNotBlank(matcher)) {
            try {
                this.jsonPath = JsonPath.compile(matcher, new Predicate[0]);
            }
            catch (Throwable throwable) {
                mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setMessageFormat("Error while creating xpath expression for [" + matcher + "] assuming matcher not xpath - " + throwable.getMessage()).setArguments(throwable));
            }
        }
    }

    @Override
    public boolean matches(HttpRequest context, String matched) {
        boolean result = false;
        boolean alreadyLoggedMatchFailure = false;
        if (this.jsonPath == null) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setHttpRequest(context).setMessageFormat("Attempting match against null json path expression for [" + matched + "]").setThrowable(new RuntimeException("Attempting match against null json path expression for [" + matched + "]")));
        } else if (this.matcher.equals(matched)) {
            result = true;
        } else if (matched != null) {
            try {
                result = !((JSONArray)this.jsonPath.read(matched)).isEmpty();
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setHttpRequest(context).setMessageFormat("Failed to perform json path match of {} with {} because {}").setArguments(matched, this.jsonPath, e.getMessage()));
                alreadyLoggedMatchFailure = true;
            }
        }
        if (!result && !alreadyLoggedMatchFailure) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Failed to perform json path match of {} with {}").setArguments(matched, this.matcher));
        }
        return this.not != result;
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

