/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.StringToXmlDocumentParser;
import org.mockserver.model.HttpRequest;
import org.slf4j.event.Level;

public class XPathMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"key", "mockServerLogger", "xpathExpression"};
    private final MockServerLogger mockServerLogger;
    private final String matcher;
    private final StringToXmlDocumentParser stringToXmlDocumentParser = new StringToXmlDocumentParser();
    private XPathExpression xpathExpression = null;

    XPathMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
        if (StringUtils.isNotBlank(matcher)) {
            try {
                this.xpathExpression = XPathFactory.newInstance().newXPath().compile(matcher);
            }
            catch (XPathExpressionException e) {
                mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Error while creating xpath expression for [" + matcher + "] assuming matcher not xpath - " + e.getMessage()).setArguments(e));
            }
        }
    }

    @Override
    public boolean matches(final HttpRequest context, String matched) {
        boolean result = false;
        if (this.xpathExpression == null) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setHttpRequest(context).setMessageFormat("Attempting match against null XPath Expression for [" + matched + "]" + new RuntimeException("Attempting match against null XPath Expression for [" + matched + "]")));
        } else if (this.matcher.equals(matched)) {
            result = true;
        } else if (matched != null) {
            try {
                result = (Boolean)this.xpathExpression.evaluate(this.stringToXmlDocumentParser.buildDocument(matched, new StringToXmlDocumentParser.ErrorLogger(){

                    @Override
                    public void logError(String matched, Exception exception) {
                        XPathMatcher.this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.WARN).setHttpRequest(context).setMessageFormat("SAXParseException while performing match between [" + XPathMatcher.this.matcher + "] and [" + matched + "]").setArguments(exception));
                    }
                }), XPathConstants.BOOLEAN);
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setHttpRequest(context).setMessageFormat("Error while matching xpath [" + this.matcher + "] against string [" + matched + "] assuming no match - " + e.getMessage()));
            }
        }
        if (!result) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setMessageFormat("Failed to perform xpath match {} with {}").setArguments(matched, this.matcher));
        }
        return this.not != result;
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

