/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.collections.CircularLinkedList;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.metrics.Metrics;
import org.mockserver.mock.Expectation;
import org.mockserver.model.Action;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.ui.MockServerMatcherNotifier;

public class MockServerMatcher
extends MockServerMatcherNotifier {
    final List<HttpRequestMatcher> httpRequestMatchers = Collections.synchronizedList(new CircularLinkedList(ConfigurationProperties.maxExpectations()));
    private WebSocketClientRegistry webSocketClientRegistry;
    private MatcherBuilder matcherBuilder;

    public MockServerMatcher(MockServerLogger logFormatter, Scheduler scheduler, WebSocketClientRegistry webSocketClientRegistry) {
        super(scheduler);
        this.matcherBuilder = new MatcherBuilder(logFormatter);
        this.webSocketClientRegistry = webSocketClientRegistry;
    }

    public void add(Expectation expectation) {
        this.httpRequestMatchers.add(this.matcherBuilder.transformsToMatcher(expectation));
        this.notifyListeners(this);
        if (expectation != null && expectation.getAction() != null) {
            Metrics.increment(expectation.getAction().getType());
        }
    }

    private HttpRequestMatcher[] cloneMatchers() {
        return this.httpRequestMatchers.toArray(new HttpRequestMatcher[0]);
    }

    public void reset() {
        this.httpRequestMatchers.clear();
        Metrics.clearActionMetrics();
        this.notifyListeners(this);
    }

    public Expectation firstMatchingExpectation(HttpRequest httpRequest) {
        Expectation matchingExpectation = null;
        for (HttpRequestMatcher httpRequestMatcher : this.cloneMatchers()) {
            boolean remainingMatchesDecremented = false;
            if (httpRequestMatcher.matches(httpRequest, httpRequest)) {
                matchingExpectation = httpRequestMatcher.getExpectation();
                if (matchingExpectation.decrementRemainingMatches()) {
                    remainingMatchesDecremented = true;
                }
            } else if (!httpRequestMatcher.isActive()) {
                this.removeHttpRequestMatcher(httpRequestMatcher);
            }
            if (remainingMatchesDecremented) {
                this.notifyListeners(this);
            }
            if (matchingExpectation != null) break;
        }
        if (matchingExpectation == null || matchingExpectation.getAction() == null) {
            Metrics.increment(Metrics.Name.EXPECTATION_NOT_MATCHED_COUNT);
        } else if (matchingExpectation.getAction().getType().direction == Action.Direction.FORWARD) {
            Metrics.increment(Metrics.Name.FORWARD_EXPECTATION_MATCHED_COUNT);
        } else {
            Metrics.increment(Metrics.Name.RESPONSE_EXPECTATION_MATCHED_COUNT);
        }
        return matchingExpectation;
    }

    public void clear(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpRequestMatcher clearHttpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (HttpRequestMatcher httpRequestMatcher : this.cloneMatchers()) {
                if (!clearHttpRequestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) continue;
                this.removeHttpRequestMatcher(httpRequestMatcher);
            }
        } else {
            this.reset();
        }
    }

    Expectation postProcess(Expectation expectation) {
        if (expectation != null && !expectation.isActive()) {
            for (HttpRequestMatcher httpRequestMatcher : this.httpRequestMatchers) {
                if (httpRequestMatcher.getExpectation() != expectation) continue;
                this.removeHttpRequestMatcher(httpRequestMatcher);
                break;
            }
        }
        return expectation;
    }

    private void removeHttpRequestMatcher(HttpRequestMatcher httpRequestMatcher) {
        if (this.httpRequestMatchers.remove(httpRequestMatcher)) {
            Action action;
            if (httpRequestMatcher.getExpectation() != null && (action = httpRequestMatcher.getExpectation().getAction()) instanceof HttpObjectCallback) {
                this.webSocketClientRegistry.unregisterClient(((HttpObjectCallback)action).getClientId());
                Metrics.decrement(action.getType());
            }
            this.notifyListeners(this);
        }
    }

    public List<Expectation> retrieveActiveExpectations(HttpRequest httpRequest) {
        if (httpRequest == null) {
            return this.httpRequestMatchers.stream().map(HttpRequestMatcher::getExpectation).collect(Collectors.toList());
        }
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (HttpRequestMatcher httpRequestMatcher : this.cloneMatchers()) {
            if (!requestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) continue;
            expectations.add(httpRequestMatcher.getExpectation());
        }
        return expectations;
    }

    public boolean isEmpty() {
        return this.httpRequestMatchers.isEmpty();
    }
}

