/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.BooleanUtils;
import org.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.callback.WebSocketRequestCallback;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.log.model.LogEntry;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.mock.action.HttpForwardAction;
import org.mockserver.mock.action.HttpForwardActionResult;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.responsewriter.ResponseWriter;
import org.slf4j.event.Level;

public class HttpForwardObjectCallbackActionHandler
extends HttpForwardAction {
    private WebSocketClientRegistry webSocketClientRegistry;

    public HttpForwardObjectCallbackActionHandler(HttpStateHandler httpStateHandler, NettyHttpClient httpClient) {
        super(httpStateHandler.getMockServerLogger(), httpClient);
        this.webSocketClientRegistry = httpStateHandler.getWebSocketClientRegistry();
    }

    public void handle(final ActionHandler actionHandler, final HttpObjectCallback httpObjectCallback, final HttpRequest request, final ResponseWriter responseWriter, final boolean synchronous, final Runnable expectationPostProcessor) {
        final String clientId = httpObjectCallback.getClientId();
        final String webSocketCorrelationId = UUID.randomUUID().toString();
        this.webSocketClientRegistry.registerForwardCallbackHandler(webSocketCorrelationId, new WebSocketRequestCallback(){

            @Override
            public void handle(HttpRequest request2) {
                HttpForwardActionResult responseFuture = HttpForwardObjectCallbackActionHandler.this.sendRequest(request2.removeHeader("WebSocketCorrelationId"), null, BooleanUtils.isTrue(httpObjectCallback.getResponseCallback()) ? response -> {
                    CompletableFuture httpResponseCompletableFuture = new CompletableFuture();
                    HttpForwardObjectCallbackActionHandler.this.webSocketClientRegistry.registerResponseCallbackHandler(webSocketCorrelationId, overriddenResponse -> {
                        HttpForwardObjectCallbackActionHandler.this.webSocketClientRegistry.unregisterResponseCallbackHandler(webSocketCorrelationId);
                        if (expectationPostProcessor != null) {
                            expectationPostProcessor.run();
                        }
                        httpResponseCompletableFuture.complete(overriddenResponse.removeHeader("WebSocketCorrelationId"));
                    });
                    if (!HttpForwardObjectCallbackActionHandler.this.webSocketClientRegistry.sendClientMessage(clientId, request2.clone().withHeader("WebSocketCorrelationId", webSocketCorrelationId), (HttpResponse)response)) {
                        HttpForwardObjectCallbackActionHandler.this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.WARN).setHttpRequest(request2).setMessageFormat("Returning {} because client " + clientId + " has closed web socket connection").setArguments(HttpResponse.notFoundResponse()));
                        actionHandler.writeForwardActionResponse(HttpForwardObjectCallbackActionHandler.this.notFoundFuture(request2), responseWriter, request2, httpObjectCallback, synchronous);
                    } else {
                        HttpForwardObjectCallbackActionHandler.this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setHttpRequest(request2).setMessageFormat("Sending request {} to client " + clientId).setArguments(request2));
                    }
                    try {
                        return (HttpResponse)httpResponseCompletableFuture.get();
                    }
                    catch (Exception e) {
                        HttpForwardObjectCallbackActionHandler.this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.WARN).setHttpRequest(request2).setMessageFormat("Exception receiving overridden response from client " + clientId + " for request {} and original response {}").setArguments(request2, response));
                        return response;
                    }
                } : null);
                HttpForwardObjectCallbackActionHandler.this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setHttpRequest(request2).setMessageFormat("Received response for request {} from client " + clientId).setArguments(request2));
                HttpForwardObjectCallbackActionHandler.this.webSocketClientRegistry.unregisterForwardCallbackHandler(webSocketCorrelationId);
                if (expectationPostProcessor != null && BooleanUtils.isFalse(httpObjectCallback.getResponseCallback())) {
                    expectationPostProcessor.run();
                }
                actionHandler.writeForwardActionResponse(responseFuture, responseWriter, request2, httpObjectCallback, synchronous);
            }

            @Override
            public void handleError(HttpResponse httpResponse) {
                HttpForwardObjectCallbackActionHandler.this.webSocketClientRegistry.unregisterForwardCallbackHandler(webSocketCorrelationId);
                actionHandler.writeResponseActionResponse(httpResponse, responseWriter, request, httpObjectCallback, synchronous);
            }
        });
        if (!this.webSocketClientRegistry.sendClientMessage(clientId, request.clone().withHeader("WebSocketCorrelationId", webSocketCorrelationId), null)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.WARN).setHttpRequest(request).setMessageFormat("Returning {} because client " + clientId + " has closed web socket connection").setArguments(HttpResponse.notFoundResponse()));
            actionHandler.writeForwardActionResponse(this.notFoundFuture(request), responseWriter, request, httpObjectCallback, synchronous);
        } else {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("Sending request {} to client " + clientId).setArguments(request));
        }
    }
}

