/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Cookies;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpObject;
import org.mockserver.model.MediaType;
import org.mockserver.model.Not;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.Parameters;
import org.mockserver.model.SocketAddress;
import org.mockserver.model.StringBody;

public class HttpRequest
extends Not
implements HttpObject<HttpRequest, Body> {
    private NottableString method = NottableString.string("");
    private NottableString path = NottableString.string("");
    private Parameters queryStringParameters;
    private Body body = null;
    private Headers headers;
    private Cookies cookies;
    private Boolean keepAlive = null;
    private Boolean secure = null;
    private SocketAddress socketAddress;

    public static HttpRequest request() {
        return new HttpRequest();
    }

    public static HttpRequest request(String path) {
        return new HttpRequest().withPath(path);
    }

    public Boolean isKeepAlive() {
        return this.keepAlive;
    }

    public HttpRequest withKeepAlive(Boolean isKeepAlive) {
        this.keepAlive = isKeepAlive;
        return this;
    }

    public Boolean isSecure() {
        return this.secure;
    }

    public HttpRequest withSecure(Boolean isSsl) {
        this.secure = isSsl;
        return this;
    }

    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public HttpRequest withSocketAddress(SocketAddress socketAddress) {
        this.socketAddress = socketAddress;
        return this;
    }

    public HttpRequest withSocketAddress(String host, Integer port, SocketAddress.Scheme scheme) {
        this.socketAddress = new SocketAddress().withHost(host).withPort(port).withScheme(scheme);
        return this;
    }

    public HttpRequest withMethod(String method) {
        return this.withMethod(NottableString.string(method));
    }

    public HttpRequest withMethod(NottableString method) {
        this.method = method;
        return this;
    }

    public NottableString getMethod() {
        return this.method;
    }

    public String getMethod(String defaultValue) {
        if (StringUtils.isBlank(this.method.getValue())) {
            return defaultValue;
        }
        return this.method.getValue();
    }

    public HttpRequest withPath(String path) {
        this.withPath(NottableString.string(path));
        return this;
    }

    public HttpRequest withPath(NottableString path) {
        this.path = path;
        return this;
    }

    public NottableString getPath() {
        return this.path;
    }

    public boolean matches(String method, String ... paths) {
        boolean matches = false;
        for (String path : paths) {
            boolean bl = matches = this.method.getValue().equals(method) && this.path.getValue().equals(path);
            if (matches) break;
        }
        return matches;
    }

    public Parameters getQueryStringParameters() {
        return this.queryStringParameters;
    }

    private Parameters getOrCreateQueryStringParameters() {
        if (this.queryStringParameters == null) {
            this.queryStringParameters = new Parameters(new Parameter[0]);
        }
        return this.queryStringParameters;
    }

    public HttpRequest withQueryStringParameters(Parameters parameters) {
        this.queryStringParameters = parameters == null || parameters.isEmpty() ? null : parameters;
        return this;
    }

    public HttpRequest withQueryStringParameters(List<Parameter> parameters) {
        this.getOrCreateQueryStringParameters().withEntries(parameters);
        return this;
    }

    public HttpRequest withQueryStringParameters(Parameter ... parameters) {
        this.getOrCreateQueryStringParameters().withEntries(parameters);
        return this;
    }

    public HttpRequest withQueryStringParameters(Map<String, List<String>> parameters) {
        this.getOrCreateQueryStringParameters().withEntries(parameters);
        return this;
    }

    public HttpRequest withQueryStringParameter(Parameter parameter) {
        this.getOrCreateQueryStringParameters().withEntry(parameter);
        return this;
    }

    public HttpRequest withQueryStringParameter(String name, String ... values) {
        this.getOrCreateQueryStringParameters().withEntry(name, values);
        return this;
    }

    public HttpRequest withQueryStringParameter(NottableString name, NottableString ... values) {
        this.getOrCreateQueryStringParameters().withEntry(name, values);
        return this;
    }

    public List<Parameter> getQueryStringParameterList() {
        if (this.queryStringParameters != null) {
            return this.queryStringParameters.getEntries();
        }
        return Collections.emptyList();
    }

    public boolean hasQueryStringParameter(String name, String value) {
        if (this.queryStringParameters != null) {
            return this.queryStringParameters.containsEntry(name, value);
        }
        return false;
    }

    public boolean hasQueryStringParameter(NottableString name, NottableString value) {
        if (this.queryStringParameters != null) {
            return this.queryStringParameters.containsEntry(name, value);
        }
        return false;
    }

    public String getFirstQueryStringParameter(String name) {
        if (this.queryStringParameters != null) {
            return this.queryStringParameters.getFirstValue(name);
        }
        return "";
    }

    @Override
    public HttpRequest withBody(String body) {
        this.body = new StringBody(body);
        return this;
    }

    @Override
    public HttpRequest withBody(String body, Charset charset) {
        if (body != null) {
            this.body = new StringBody(body, charset);
        }
        return this;
    }

    @Override
    public HttpRequest withBody(byte[] body) {
        this.body = new BinaryBody(body);
        return this;
    }

    @Override
    public HttpRequest withBody(Body body) {
        this.body = body;
        return this;
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    @JsonIgnore
    public byte[] getBodyAsRawBytes() {
        return this.body != null ? this.body.getRawBytes() : new byte[]{};
    }

    @Override
    @JsonIgnore
    public String getBodyAsString() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    private Headers getOrCreateHeaders() {
        if (this.headers == null) {
            this.headers = new Headers(new Header[0]);
        }
        return this.headers;
    }

    @Override
    public HttpRequest withHeaders(Headers headers) {
        this.headers = headers == null || headers.isEmpty() ? null : headers;
        return this;
    }

    @Override
    public HttpRequest withHeaders(List<Header> headers) {
        this.getOrCreateHeaders().withEntries(headers);
        return this;
    }

    @Override
    public HttpRequest withHeaders(Header ... headers) {
        this.getOrCreateHeaders().withEntries(headers);
        return this;
    }

    @Override
    public HttpRequest withHeader(Header header) {
        this.getOrCreateHeaders().withEntry(header);
        return this;
    }

    @Override
    public HttpRequest withHeader(String name, String ... values) {
        this.getOrCreateHeaders().withEntry(Header.header(name, values));
        return this;
    }

    @Override
    public HttpRequest withHeader(NottableString name, NottableString ... values) {
        this.getOrCreateHeaders().withEntry(Header.header(name, values));
        return this;
    }

    @Override
    public HttpRequest withContentType(MediaType mediaType) {
        this.getOrCreateHeaders().withEntry(Header.header(HttpHeaderNames.CONTENT_TYPE.toString(), mediaType.toString()));
        return this;
    }

    @Override
    public HttpRequest replaceHeader(Header header) {
        this.getOrCreateHeaders().replaceEntry(header);
        return this;
    }

    @Override
    public List<Header> getHeaderList() {
        if (this.headers != null) {
            return this.headers.getEntries();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getHeader(String name) {
        if (this.headers != null) {
            return this.headers.getValues(name);
        }
        return Collections.emptyList();
    }

    @Override
    public String getFirstHeader(String name) {
        if (this.headers != null) {
            return this.headers.getFirstValue(name);
        }
        return "";
    }

    @Override
    public boolean containsHeader(String name) {
        if (this.headers != null) {
            return this.headers.containsEntry(name);
        }
        return false;
    }

    public boolean containsHeader(String name, String value) {
        if (this.headers != null) {
            return this.headers.containsEntry(name, value);
        }
        return false;
    }

    @Override
    public HttpRequest removeHeader(String name) {
        if (this.headers != null) {
            this.headers.remove(name);
        }
        return this;
    }

    @Override
    public HttpRequest removeHeader(NottableString name) {
        if (this.headers != null) {
            this.headers.remove(name);
        }
        return this;
    }

    @Override
    public Cookies getCookies() {
        return this.cookies;
    }

    private Cookies getOrCreateCookies() {
        if (this.cookies == null) {
            this.cookies = new Cookies(new Cookie[0]);
        }
        return this.cookies;
    }

    @Override
    public HttpRequest withCookies(Cookies cookies) {
        this.cookies = cookies == null || cookies.isEmpty() ? null : cookies;
        return this;
    }

    @Override
    public HttpRequest withCookies(List<Cookie> cookies) {
        this.getOrCreateCookies().withEntries(cookies);
        return this;
    }

    @Override
    public HttpRequest withCookies(Cookie ... cookies) {
        this.getOrCreateCookies().withEntries(cookies);
        return this;
    }

    @Override
    public HttpRequest withCookie(Cookie cookie) {
        this.getOrCreateCookies().withEntry(cookie);
        return this;
    }

    @Override
    public HttpRequest withCookie(String name, String value) {
        this.getOrCreateCookies().withEntry(name, value);
        return this;
    }

    @Override
    public HttpRequest withCookie(NottableString name, NottableString value) {
        this.getOrCreateCookies().withEntry(name, value);
        return this;
    }

    @Override
    public List<Cookie> getCookieList() {
        if (this.cookies != null) {
            return this.cookies.getEntries();
        }
        return Collections.emptyList();
    }

    public InetSocketAddress socketAddressFromHostHeader() {
        if (this.socketAddress != null && this.socketAddress.getHost() != null) {
            boolean isSsl = this.socketAddress.getScheme() != null && this.socketAddress.getScheme().equals((Object)SocketAddress.Scheme.HTTPS);
            return new InetSocketAddress(this.socketAddress.getHost(), this.socketAddress.getPort() != null ? this.socketAddress.getPort() : (isSsl ? 443 : 80));
        }
        if (StringUtils.isNotBlank(this.getFirstHeader(HttpHeaderNames.HOST.toString()))) {
            boolean isSsl = this.isSecure() != null && this.isSecure() != false;
            String[] hostHeaderParts = this.getFirstHeader(HttpHeaderNames.HOST.toString()).split(":");
            return new InetSocketAddress(hostHeaderParts[0], hostHeaderParts.length > 1 ? Integer.parseInt(hostHeaderParts[1]) : (isSsl ? 443 : 80));
        }
        throw new IllegalArgumentException("Host header must be provided to determine remote socket address, the request does not include the \"Host\" header:" + Character.NEW_LINE + this);
    }

    public HttpRequest clone() {
        return HttpRequest.not(HttpRequest.request(), this.not).withMethod(this.method).withPath(this.path).withQueryStringParameters(this.queryStringParameters != null ? this.queryStringParameters.clone() : null).withBody(this.body).withHeaders(this.headers != null ? this.headers.clone() : null).withCookies(this.cookies != null ? this.cookies.clone() : null).withKeepAlive(this.keepAlive).withSecure(this.secure).withSocketAddress(this.socketAddress);
    }

    public HttpRequest update(HttpRequest replaceRequest) {
        if (replaceRequest.getMethod() != null && StringUtils.isNotBlank(replaceRequest.getMethod().getValue())) {
            this.withMethod(replaceRequest.getMethod());
        }
        if (replaceRequest.getPath() != null && StringUtils.isNotBlank(replaceRequest.getPath().getValue())) {
            this.withPath(replaceRequest.getPath());
        }
        for (Header header : replaceRequest.getHeaderList()) {
            this.getOrCreateHeaders().replaceEntry(header);
        }
        for (Cookie cookie : replaceRequest.getCookieList()) {
            this.withCookie(cookie);
        }
        for (Parameter parameter : replaceRequest.getQueryStringParameterList()) {
            this.getOrCreateQueryStringParameters().replaceEntry(parameter);
        }
        if (replaceRequest.getBody() != null) {
            this.withBody(replaceRequest.getBody());
        }
        if (replaceRequest.isSecure() != null) {
            this.withSecure(replaceRequest.isSecure());
        }
        if (replaceRequest.isKeepAlive() != null) {
            this.withKeepAlive(replaceRequest.isKeepAlive());
        }
        if (replaceRequest.getSocketAddress() != null) {
            this.withSocketAddress(replaceRequest.getSocketAddress());
        }
        return this;
    }
}

