/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.ObjectWithJsonToString;
import org.mockserver.serialization.ObjectMapperFactory;
import org.slf4j.event.Level;

public class MediaType
extends ObjectWithJsonToString {
    public static final Charset DEFAULT_HTTP_CHARACTER_SET = CharsetUtil.ISO_8859_1;
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(ObjectMapperFactory.class);
    private static final char TYPE_SEPARATOR = '/';
    private static final char PARAMETER_START = ';';
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    private final Charset charset;
    private final String toString;
    private final boolean isBlank;
    private static final String CHARSET_PARAMETER = "charset";
    private static final String MEDIA_TYPE_WILDCARD = "*";
    public static final MediaType WILDCARD = new MediaType("*", "*");
    public static final MediaType APPLICATION_ATOM_XML = new MediaType("application", "atom+xml");
    public static final MediaType APPLICATION_XHTML_XML = new MediaType("application", "xhtml+xml");
    public static final MediaType APPLICATION_SVG_XML = new MediaType("application", "svg+xml");
    public static final MediaType APPLICATION_XML = new MediaType("application", "xml");
    public static final MediaType APPLICATION_XML_UTF_8 = new MediaType("application", "xml", "utf-8", null);
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json");
    public static final MediaType APPLICATION_JSON_UTF_8;
    public static final MediaType JSON_UTF_8;
    public static final MediaType APPLICATION_FORM_URLENCODED;
    public static final MediaType FORM_DATA;
    public static final MediaType MULTIPART_FORM_DATA;
    public static final MediaType APPLICATION_OCTET_STREAM;
    public static final MediaType APPLICATION_BINARY;
    public static final MediaType PDF;
    public static final MediaType ATOM_UTF_8;
    public static final MediaType TEXT_PLAIN;
    public static final MediaType PLAIN_TEXT_UTF_8;
    public static final MediaType TEXT_XML;
    public static final MediaType TEXT_XML_UTF_8;
    public static final MediaType XML_UTF_8;
    public static final MediaType TEXT_HTML;
    public static final MediaType TEXT_HTML_UTF_8;
    public static final MediaType HTML_UTF_8;
    public static final MediaType SERVER_SENT_EVENTS;
    public static final MediaType APPLICATION_JSON_PATCH_JSON;
    public static final MediaType ANY_VIDEO_TYPE;
    public static final MediaType ANY_AUDIO_TYPE;
    public static final MediaType ANY_IMAGE_TYPE;
    public static final MediaType QUICKTIME;
    public static final MediaType JPEG;
    public static final MediaType PNG;

    public static MediaType parse(String mediaTypeHeader) {
        if (StringUtils.isNotBlank(mediaTypeHeader)) {
            int typeSeparator = mediaTypeHeader.indexOf(47);
            int typeEndIndex = 0;
            String type = null;
            String subType = null;
            if (typeSeparator != -1) {
                typeEndIndex = mediaTypeHeader.indexOf(59);
                if (typeEndIndex == -1) {
                    typeEndIndex = mediaTypeHeader.length();
                }
                String typeString = mediaTypeHeader.substring(0, typeEndIndex).trim();
                type = StringUtils.substringBefore(typeString, "/").trim().toLowerCase();
                subType = StringUtils.substringAfter(typeString, "/").trim().toLowerCase();
                if (typeEndIndex < mediaTypeHeader.length()) {
                    ++typeEndIndex;
                }
            }
            String parameters = mediaTypeHeader.substring(typeEndIndex).trim().toLowerCase().replaceAll("\"", "");
            Map parameterMap = null;
            if (StringUtils.isNotBlank(parameters) && (parameterMap = Splitter.on(';').trimResults().omitEmptyStrings().withKeyValueSeparator('=').split(parameters)).size() > 1) {
                parameterMap = parameterMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            }
            return new MediaType(type, subType, parameterMap);
        }
        return new MediaType(null, null);
    }

    private static TreeMap<String, String> createParametersMap(Map<String, String> initialValues) {
        TreeMap<String, String> map = new TreeMap<String, String>(String::compareToIgnoreCase);
        if (initialValues != null) {
            for (Map.Entry<String, String> entry : initialValues.entrySet()) {
                map.put(entry.getKey().toLowerCase().trim(), entry.getValue().trim());
            }
        }
        return map;
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, null, null);
    }

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        this(type, subtype, null, parameters);
    }

    private MediaType(String type, String subtype, String charset, Map<String, String> parameterMap) {
        this.type = StringUtils.isBlank(type) ? null : type;
        this.subtype = StringUtils.isBlank(subtype) ? null : subtype;
        this.parameters = new TreeMap<String, String>(String::compareToIgnoreCase);
        if (parameterMap != null) {
            for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
                this.parameters.put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }
        Charset parsedCharset = null;
        if (StringUtils.isNotBlank(charset)) {
            this.parameters.put(CHARSET_PARAMETER, charset);
            try {
                parsedCharset = Charset.forName(charset);
            }
            catch (Throwable throwable) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Ignoring unsupported charset with value \"" + charset + "\"").setThrowable(throwable));
            }
        } else {
            try {
                if (this.parameters.containsKey(CHARSET_PARAMETER)) {
                    parsedCharset = Charset.forName(this.parameters.get(CHARSET_PARAMETER));
                }
            }
            catch (Throwable throwable) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Ignoring unsupported charset with value \"" + charset + "\"").setThrowable(throwable));
            }
        }
        this.charset = parsedCharset;
        this.toString = this.initialiseToString();
        this.isBlank = StringUtils.isBlank(this.toString);
    }

    private String initialiseToString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.type != null && this.subtype != null) {
            stringBuilder.append(this.type).append('/').append(this.subtype);
        }
        if (!this.parameters.isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(';').append(' ');
            }
            stringBuilder.append(Joiner.on("; ").withKeyValueSeparator("=").join(this.parameters));
        }
        return stringBuilder.toString();
    }

    public static MediaType create(String type, String subType) {
        return new MediaType(type, subType);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public MediaType withCharset(Charset charset) {
        return this.withCharset(charset.name());
    }

    public MediaType withCharset(String charset) {
        return new MediaType(this.type, this.subtype, charset.toLowerCase(), this.parameters);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Charset getCharsetOrDefault() {
        if (this.charset != null) {
            return this.charset;
        }
        return DEFAULT_HTTP_CHARACTER_SET;
    }

    public boolean isCompatible(MediaType other) {
        return other != null && (this.type == null || other.type == null || this.type.equals(MEDIA_TYPE_WILDCARD) || other.type.equals(MEDIA_TYPE_WILDCARD) || this.type.equalsIgnoreCase(other.type) && (this.subtype == null || other.subtype == null) || this.type.equalsIgnoreCase(other.type) && (this.subtype.equals(MEDIA_TYPE_WILDCARD) || other.subtype.equals(MEDIA_TYPE_WILDCARD)) || this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype));
    }

    public boolean isJson() {
        return !this.isBlank && this.contentTypeContains(new String[]{"json"});
    }

    public boolean isXml() {
        return !this.isBlank && this.contentTypeContains(new String[]{"xml"});
    }

    public boolean isString() {
        return this.isBlank || this.contentTypeContains(new String[]{"utf-8", "utf8", "text", "json", "css", "html", "xhtml", "form", "javascript", "ecmascript", "xml", "wsdl", "csv", "urlencoded"});
    }

    private boolean contentTypeContains(String[] subStrings) {
        String contentType = this.toString().toLowerCase();
        for (String subString : subStrings) {
            if (!contentType.contains(subString)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.toString;
    }

    static {
        JSON_UTF_8 = APPLICATION_JSON_UTF_8 = new MediaType("application", "json", "utf-8", null);
        APPLICATION_FORM_URLENCODED = new MediaType("application", "x-www-form-urlencoded");
        FORM_DATA = new MediaType("application", "x-www-form-urlencoded");
        MULTIPART_FORM_DATA = new MediaType("multipart", "form-data");
        APPLICATION_OCTET_STREAM = new MediaType("application", "octet-stream");
        APPLICATION_BINARY = new MediaType("application", "binary");
        PDF = new MediaType("application", "pdf");
        ATOM_UTF_8 = new MediaType("application", "atom+xml", "utf-8", null);
        TEXT_PLAIN = new MediaType("text", "plain");
        PLAIN_TEXT_UTF_8 = new MediaType("text", "plain", "utf-8", null);
        TEXT_XML = new MediaType("text", "xml");
        XML_UTF_8 = TEXT_XML_UTF_8 = new MediaType("text", "xml", "utf-8", null);
        TEXT_HTML = new MediaType("text", "html");
        HTML_UTF_8 = TEXT_HTML_UTF_8 = new MediaType("text", "html", "utf-8", null);
        SERVER_SENT_EVENTS = new MediaType("text", "event-stream");
        APPLICATION_JSON_PATCH_JSON = new MediaType("application", "json-patch+json");
        ANY_VIDEO_TYPE = new MediaType("video", MEDIA_TYPE_WILDCARD);
        ANY_AUDIO_TYPE = new MediaType("audio", MEDIA_TYPE_WILDCARD);
        ANY_IMAGE_TYPE = new MediaType("image", MEDIA_TYPE_WILDCARD);
        QUICKTIME = new MediaType("video", "quicktime");
        JPEG = new MediaType("image", "jpeg");
        PNG = new MediaType("image", "png");
    }
}

