/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.serializers.response.TimeToLiveSerializer;
import org.mockserver.ui.MockServerMatcherListener;
import org.slf4j.event.Level;

public class ExpectationFileSystemPersistence
implements MockServerMatcherListener {
    private final ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper(new TimeToLiveSerializer());
    private final MockServerLogger mockServerLogger;
    private final Path filePath;

    public ExpectationFileSystemPersistence(MockServerLogger mockServerLogger, MockServerMatcher mockServerMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.filePath = Paths.get(ConfigurationProperties.persistedExpectationsPath(), new String[0]);
        if (ConfigurationProperties.persistExpectations()) {
            try {
                Files.createFile(this.filePath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (Throwable throwable) {
                mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception creating persisted expectations file " + this.filePath.toString()).setThrowable(throwable));
            }
            mockServerMatcher.registerListener(this);
        }
    }

    @Override
    public void updated(MockServerMatcher mockServerLog) {
        try {
            Files.write(this.filePath, this.serialize(mockServerLog.retrieveActiveExpectations(null)).getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while persisting expectations to " + this.filePath.toString()).setThrowable(throwable));
        }
    }

    public String serialize(List<Expectation> expectations) {
        return this.serialize(expectations.toArray(new Expectation[0]));
    }

    public String serialize(Expectation ... expectations) {
        try {
            if (expectations != null && expectations.length > 0) {
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(expectations);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while serializing expectation to JSON with value " + Arrays.asList(expectations)).setThrowable(e));
            throw new RuntimeException("Exception while serializing expectation to JSON with value " + Arrays.asList(expectations), e);
        }
    }
}

