/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.socks;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mockserver.MockServerHandler;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.unification.PortUnificationHandler;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public abstract class SocksProxyHandler<T>
extends SimpleChannelInboundHandler<T> {
    protected final LifeCycle server;
    protected final MockServerLogger mockServerLogger;

    public SocksProxyHandler(LifeCycle server, MockServerLogger mockServerLogger) {
        super(false);
        this.server = server;
        this.mockServerLogger = mockServerLogger;
    }

    protected void forwardConnection(ChannelHandlerContext ctx, ChannelHandler forwarder, String addr, int port) {
        Channel channel = ctx.channel();
        channel.attr(MockServerHandler.PROXYING).set(Boolean.TRUE);
        if (String.valueOf(port).endsWith("80")) {
            PortUnificationHandler.disableSslDownstream(channel);
        } else if (String.valueOf(port).endsWith("443")) {
            PortUnificationHandler.enableSslDownstream(channel);
        }
        this.server.getScheduler().submit(() -> KeyAndCertificateFactory.addSubjectAlternativeName(addr));
        ctx.pipeline().replace(this, null, forwarder);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandler.shouldNotIgnoreException(cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception caught by SOCKS proxy handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ctx.close();
    }
}

