/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.VerificationSequenceDTO;
import org.mockserver.validator.jsonschema.JsonSchemaVerificationSequenceValidator;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.event.Level;

public class VerificationSequenceSerializer
implements Serializer<VerificationSequence> {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);
    private JsonSchemaVerificationSequenceValidator verificationSequenceValidator;

    public VerificationSequenceSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.verificationSequenceValidator = new JsonSchemaVerificationSequenceValidator(mockServerLogger);
    }

    @Override
    public String serialize(VerificationSequence verificationSequence) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(new VerificationSequenceDTO(verificationSequence));
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while serializing verificationSequence to JSON with value " + verificationSequence).setThrowable(e));
            throw new RuntimeException("Exception while serializing verificationSequence to JSON with value " + verificationSequence, e);
        }
    }

    @Override
    public VerificationSequence deserialize(String jsonVerificationSequence) {
        if (StringUtils.isBlank(jsonVerificationSequence)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a verification sequence is required but value was \"" + jsonVerificationSequence + "\"");
        }
        String validationErrors = this.verificationSequenceValidator.isValid(jsonVerificationSequence);
        if (validationErrors.isEmpty()) {
            VerificationSequence verificationSequence = null;
            try {
                VerificationSequenceDTO verificationDTO = this.objectMapper.readValue(jsonVerificationSequence, VerificationSequenceDTO.class);
                if (verificationDTO != null) {
                    verificationSequence = verificationDTO.buildObject();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while parsing {} for VerificationSequence").setArguments(jsonVerificationSequence).setThrowable(e));
                throw new RuntimeException("Exception while parsing [" + jsonVerificationSequence + "] for VerificationSequence", e);
            }
            return verificationSequence;
        }
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.VERIFICATION_FAILED).setLogLevel(Level.INFO).setHttpRequest(HttpRequest.request()).setMessageFormat("validation failed:{}verification sequence:{}").setArguments(validationErrors, jsonVerificationSequence));
        throw new IllegalArgumentException(validationErrors);
    }

    @Override
    public Class<VerificationSequence> supportsType() {
        return VerificationSequence.class;
    }
}

