/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.deserializers.condition;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.serialization.model.TimeToLiveDTO;
import org.slf4j.event.Level;

public class TimeToLiveDTODeserializer
extends StdDeserializer<TimeToLiveDTO> {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger();

    public TimeToLiveDTODeserializer() {
        super(TimeToLiveDTO.class);
    }

    @Override
    public TimeToLiveDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        TimeToLiveDTO timeToLiveDTO = null;
        TimeToLive timeToLive = null;
        long ttl = 0L;
        boolean unlimited = false;
        JsonNode timeToLiveDTONode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode unlimitedNode = timeToLiveDTONode.get("unlimited");
        if (unlimitedNode != null) {
            unlimited = unlimitedNode.asBoolean();
        }
        if (!unlimited) {
            JsonNode timeUnitNode;
            JsonNode timeToLiveNode = timeToLiveDTONode.get("timeToLive");
            if (timeToLiveNode != null) {
                ttl = timeToLiveNode.asLong();
            }
            if ((timeUnitNode = timeToLiveDTONode.get("timeUnit")) != null) {
                try {
                    TimeUnit timeUnit = Enum.valueOf(TimeUnit.class, timeUnitNode.asText());
                    timeToLive = TimeToLive.exactly(timeUnit, ttl);
                }
                catch (IllegalArgumentException iae) {
                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.TRACE).setMessageFormat("Exception parsing TimeToLiveDTO timeUnit").setThrowable(iae));
                }
            }
            if (timeToLive != null) {
                JsonNode endDateNode = timeToLiveDTONode.get("endDate");
                if (endDateNode != null) {
                    long endDate = endDateNode.asLong();
                    timeToLive.setEndDate(endDate);
                }
                timeToLiveDTO = new TimeToLiveDTO(timeToLive);
            }
        } else {
            timeToLiveDTO = new TimeToLiveDTO(TimeToLive.unlimited());
        }
        return timeToLiveDTO;
    }
}

