/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.deserializers.string;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.NottableString;

public class NottableStringDeserializer
extends StdDeserializer<NottableString> {
    public NottableStringDeserializer() {
        super(NottableString.class);
    }

    @Override
    public NottableString deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
            Boolean not = null;
            String string = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jsonParser.getCurrentName();
                if ("not".equals(fieldName)) {
                    jsonParser.nextToken();
                    not = jsonParser.getBooleanValue();
                    continue;
                }
                if (!"value".equals(fieldName)) continue;
                jsonParser.nextToken();
                string = ctxt.readValue(jsonParser, String.class);
            }
            if (StringUtils.isEmpty(string)) {
                return null;
            }
            return NottableString.string(string, not);
        }
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING || jsonParser.getCurrentToken() == JsonToken.FIELD_NAME) {
            return NottableString.string(ctxt.readValue(jsonParser, String.class));
        }
        return null;
    }
}

