/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Strings;
import org.mockserver.character.Character;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.serialization.java.ToJavaSerializer;

public class TimeToLiveToJavaSerializer
implements ToJavaSerializer<TimeToLive> {
    @Override
    public String serialize(int numberOfSpacesToIndent, TimeToLive timeToLive) {
        StringBuffer output = new StringBuffer();
        if (timeToLive != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output);
            if (timeToLive.isUnlimited()) {
                output.append("TimeToLive.unlimited()");
            } else {
                output.append("TimeToLive.exactly(TimeUnit.").append(timeToLive.getTimeUnit().name()).append(", ").append(timeToLive.getTimeToLive()).append("L)");
            }
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart("", numberOfSpacesToIndent, ' '));
    }
}

