/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.server.initialize;

import java.lang.reflect.Constructor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.server.initialize.ExpectationInitializer;
import org.slf4j.event.Level;

public class ExpectationInitializerLoader {
    private final ExpectationSerializer expectationSerializer;
    private final MockServerLogger mockServerLogger;
    private final MockServerMatcher mockServerMatcher;

    public ExpectationInitializerLoader(MockServerLogger mockServerLogger, MockServerMatcher mockServerMatcher) {
        this.expectationSerializer = new ExpectationSerializer(mockServerLogger);
        this.mockServerLogger = mockServerLogger;
        this.mockServerMatcher = mockServerMatcher;
        this.addExpectationsFromInitializer();
    }

    private void addExpectationsFromInitializer() {
        for (Expectation expectation : this.loadExpectations()) {
            this.mockServerMatcher.add(expectation);
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CREATED_EXPECTATION).setLogLevel(Level.INFO).setHttpRequest(expectation.getHttpRequest()).setMessageFormat("creating expectation:{}").setArguments(expectation.clone()));
        }
    }

    private Expectation[] retrieveExpectationsFromInitializerClass() {
        try {
            Constructor<?> initializerClassConstructor;
            Object expectationInitializer;
            ClassLoader contextClassLoader;
            String initializationClass = ConfigurationProperties.initializationClass();
            if (StringUtils.isNotBlank(initializationClass) && (contextClassLoader = ExpectationInitializerLoader.class.getClassLoader()) != null && StringUtils.isNotEmpty(initializationClass) && (expectationInitializer = (initializerClassConstructor = contextClassLoader.loadClass(initializationClass).getDeclaredConstructor(new Class[0])).newInstance(new Object[0])) instanceof ExpectationInitializer) {
                return ((ExpectationInitializer)expectationInitializer).initializeExpectations();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Expectation[0];
    }

    private Expectation[] retrieveExpectationsFromJson() {
        String initializationJsonPath = ConfigurationProperties.initializationJsonPath();
        if (StringUtils.isNotBlank(initializationJsonPath)) {
            try {
                return this.expectationSerializer.deserializeArray(FileReader.readFileFromClassPathOrPath(initializationJsonPath));
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.WARN).setMessageFormat("Exception while loading JSON initialization file, ignoring file").setThrowable(throwable));
            }
        }
        return new Expectation[0];
    }

    public Expectation[] loadExpectations() {
        Expectation[] expectationsFromInitializerClass = this.retrieveExpectationsFromInitializerClass();
        Expectation[] expectationsFromJson = this.retrieveExpectationsFromJson();
        return ArrayUtils.addAll(expectationsFromInitializerClass, expectationsFromJson);
    }
}

