/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.AbstractSniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.socket.tls.NettySslContextFactory;

public class SniHandler
extends AbstractSniHandler<SslContext> {
    private final NettySslContextFactory nettySslContextFactory;

    public SniHandler(NettySslContextFactory nettySslContextFactory) {
        this.nettySslContextFactory = nettySslContextFactory;
    }

    @Override
    protected Future<SslContext> lookup(ChannelHandlerContext ctx, String hostname) {
        if (StringUtils.isNotBlank(hostname)) {
            ConfigurationProperties.addSslSubjectAlternativeNameDomains(hostname);
        }
        return ctx.executor().newSucceededFuture(this.nettySslContextFactory.createServerSslContext());
    }

    @Override
    protected void onLookupComplete(ChannelHandlerContext ctx, String hostname, Future<SslContext> sslContextFuture) {
        if (!sslContextFuture.isSuccess()) {
            Throwable cause = sslContextFuture.cause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new DecoderException("Failed to get the SslContext for " + hostname, cause);
        }
        try {
            this.replaceHandler(ctx, sslContextFuture);
        }
        catch (Throwable cause) {
            PlatformDependent.throwException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceHandler(ChannelHandlerContext ctx, Future<SslContext> sslContext) {
        SslHandler sslHandler = null;
        try {
            sslHandler = sslContext.getNow().newHandler(ctx.alloc());
            ctx.pipeline().replace(this, SslHandler.class.getName(), (ChannelHandler)sslHandler);
            sslHandler = null;
        }
        finally {
            if (sslHandler != null) {
                ReferenceCountUtil.safeRelease(sslHandler.engine());
            }
        }
    }
}

