/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.streams;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.io.IOUtils;
import org.mockserver.character.Character;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.slf4j.event.Level;

public class IOStreamUtils {
    private final MockServerLogger mockServerLogger;

    public IOStreamUtils(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    public static String readInputStreamToString(Socket socket) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        StringBuilder result = new StringBuilder();
        Integer contentLength = null;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.startsWith("content-length") || line.startsWith("Content-Length")) {
                contentLength = Integer.parseInt(line.split(":")[1].trim());
            }
            if (line.length() == 0) {
                if (contentLength == null) break;
                result.append(Character.NEW_LINE);
                for (int position = 0; position < contentLength; ++position) {
                    result.append((char)bufferedReader.read());
                }
                break;
            }
            result.append(line).append(Character.NEW_LINE);
        }
        return result.toString();
    }

    public String readInputStreamToString(ServletRequest request) {
        try {
            return IOUtils.toString((InputStream)request.getInputStream(), StandardCharsets.UTF_8.name());
        }
        catch (IOException ioe) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("IOException while reading HttpServletRequest input stream").setThrowable(ioe));
            throw new RuntimeException("IOException while reading HttpServletRequest input stream", ioe);
        }
    }

    public void writeToOutputStream(byte[] data, ServletResponse response) {
        try {
            ServletOutputStream output = response.getOutputStream();
            output.write(data);
            output.close();
        }
        catch (IOException ioe) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("IOException while writing [" + new String(data) + "] to HttpServletResponse output stream").setThrowable(ioe));
            throw new RuntimeException("IOException while writing [" + new String(data) + "] to HttpServletResponse output stream", ioe);
        }
    }
}

