/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.validator.xmlschema;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.file.FileReader;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.validator.Validator;
import org.slf4j.event.Level;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XmlSchemaValidator
extends ObjectWithReflectiveEqualsHashCodeToString
implements Validator<String> {
    private static SchemaFactory schemaFactory;
    private final MockServerLogger mockServerLogger;
    private final Schema schema;

    public XmlSchemaValidator(MockServerLogger mockServerLogger, String schema) {
        block5: {
            this.mockServerLogger = mockServerLogger;
            try {
                if (schemaFactory == null) {
                    schemaFactory = this.buildSchemaFactory();
                }
                if (schema.trim().endsWith(">") || StringUtils.isBlank(schema)) {
                    this.schema = schemaFactory.newSchema(new StreamSource(new StringReader(schema)));
                    break block5;
                }
                if (schema.trim().endsWith(".xsd")) {
                    this.schema = schemaFactory.newSchema(new StreamSource(FileReader.openReaderToFileFromClassPathOrPath(schema)));
                    break block5;
                }
                throw new IllegalArgumentException("Schema must either be a path reference to a *.xsd file or an xml string");
            }
            catch (Exception e) {
                mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception parsing schema {}").setArguments(schema).setThrowable(e));
                throw new RuntimeException(StringFormatter.formatLogMessage("exception parsing schema {}", schema), e);
            }
        }
    }

    private SchemaFactory buildSchemaFactory() throws SAXNotRecognizedException, SAXNotSupportedException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "all");
        schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "all");
        return schemaFactory;
    }

    @Override
    public String isValid(String xml) {
        String errorMessage = "";
        try {
            try {
                this.schema.newValidator().validate(new StreamSource(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8))));
            }
            catch (SAXException e) {
                errorMessage = e.getMessage();
            }
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception validating JSON").setThrowable(e));
            return e.getClass().getSimpleName() + " - " + e.getMessage();
        }
        return errorMessage;
    }
}

