/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.server;

import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.mappers.HttpServerRequestMapper;
import org.mockserver.mappers.HttpServerResponseMapper;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServer;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.platform.Verticle;

public class MockServerVertical
extends Verticle {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final MockServer mockServer = new MockServer();
    private final HttpServerRequestMapper httpServerRequestMapper = new HttpServerRequestMapper();
    private final HttpServerResponseMapper httpServerResponseMapper = new HttpServerResponseMapper();
    private final ExpectationSerializer expectationSerializer = new ExpectationSerializer();

    public void start() {
        HttpServer server = this.vertx.createHttpServer();
        server.requestHandler((Handler)new Handler<HttpServerRequest>(){

            public void handle(final HttpServerRequest request) {
                final Buffer body = new Buffer(0);
                request.dataHandler((Handler)new Handler<Buffer>(){

                    public void handle(Buffer buffer) {
                        body.appendBuffer(buffer);
                    }
                });
                request.endHandler((Handler)new VoidHandler(){

                    public void handle() {
                        if (request.method().equals("PUT")) {
                            if (request.path().equals("/stop")) {
                                request.response().setStatusCode(HttpStatusCode.ACCEPTED_202.code);
                                request.response().setStatusMessage(HttpStatusCode.ACCEPTED_202.message);
                                request.response().end();
                                MockServerVertical.this.vertx.stop();
                            } else if (request.path().equals("/clear")) {
                                Expectation expectation = MockServerVertical.this.expectationSerializer.deserialize(body.getBytes());
                                MockServerVertical.this.mockServer.clear(expectation.getHttpRequest());
                                request.response().setStatusCode(HttpStatusCode.ACCEPTED_202.code);
                                request.response().setStatusMessage(HttpStatusCode.ACCEPTED_202.message);
                            } else {
                                Expectation expectation = MockServerVertical.this.expectationSerializer.deserialize(body.getBytes());
                                MockServerVertical.this.mockServer.when(expectation.getHttpRequest(), expectation.getTimes()).respond(expectation.getHttpResponse());
                                request.response().setStatusCode(HttpStatusCode.CREATED_201.code);
                                request.response().setStatusMessage(HttpStatusCode.CREATED_201.message);
                            }
                        } else if (request.method().equals("GET") || request.method().equals("POST")) {
                            HttpRequest httpRequest = MockServerVertical.this.httpServerRequestMapper.createHttpRequest(request, body.getBytes());
                            HttpResponse httpResponse = MockServerVertical.this.mockServer.handle(httpRequest);
                            if (httpResponse != null) {
                                MockServerVertical.this.httpServerResponseMapper.mapHttpServerResponse(httpResponse, request.response());
                            } else {
                                request.response().setStatusCode(HttpStatusCode.NOT_FOUND_404.code);
                                request.response().setStatusMessage(HttpStatusCode.NOT_FOUND_404.message);
                            }
                        }
                        if (!request.path().equals("/stop")) {
                            request.response().end();
                        }
                    }
                });
            }
        }).listen(8080, "localhost");
    }
}

