/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.server;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.mappers.HttpServletToMockServerRequestMapper;
import org.mockserver.mappers.MockServerToHttpServletResponseMapper;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.proxy.filters.LogFilter;
import org.mockserver.streams.IOStreamUtils;

public class MockServerServlet
extends HttpServlet {
    private static final long serialVersionUID = 5058943788293770703L;
    private MockServerMatcher mockServerMatcher = new MockServerMatcher();
    private HttpServletToMockServerRequestMapper httpServletToMockServerRequestMapper = new HttpServletToMockServerRequestMapper();
    private MockServerToHttpServletResponseMapper mockServerToHttpServletResponseMapper = new MockServerToHttpServletResponseMapper();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private LogFilter logFilter = new LogFilter();

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.mockResponse(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.mockResponse(httpServletRequest, httpServletResponse);
    }

    public void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String requestPath;
        String string = requestPath = httpServletRequest.getPathInfo() != null && httpServletRequest.getContextPath() != null ? httpServletRequest.getPathInfo() : httpServletRequest.getRequestURI();
        if (requestPath.equals("/stop")) {
            httpServletResponse.setStatus(HttpStatusCode.NOT_IMPLEMENTED_501.code());
        } else if (requestPath.equals("/dumpToLog")) {
            this.mockServerMatcher.dumpToLog(this.httpRequestSerializer.deserialize(IOStreamUtils.readInputStreamToString((ServletRequest)httpServletRequest)));
            httpServletResponse.setStatus(HttpStatusCode.ACCEPTED_202.code());
        } else if (requestPath.equals("/reset")) {
            this.logFilter.reset();
            this.mockServerMatcher.reset();
            httpServletResponse.setStatus(HttpStatusCode.ACCEPTED_202.code());
        } else if (requestPath.equals("/clear")) {
            HttpRequest httpRequest = this.httpRequestSerializer.deserialize(IOStreamUtils.readInputStreamToString((ServletRequest)httpServletRequest));
            this.logFilter.clear(httpRequest);
            this.mockServerMatcher.clear(httpRequest);
            httpServletResponse.setStatus(HttpStatusCode.ACCEPTED_202.code());
        } else if (requestPath.equals("/expectation")) {
            Expectation expectation = this.expectationSerializer.deserialize(IOStreamUtils.readInputStreamToString((ServletRequest)httpServletRequest));
            this.mockServerMatcher.when(expectation.getHttpRequest(), expectation.getTimes()).thenRespond(expectation.getHttpResponse());
            httpServletResponse.setStatus(HttpStatusCode.CREATED_201.code());
        } else if (requestPath.equals("/retrieve")) {
            Expectation[] expectations = this.logFilter.retrieve(this.httpRequestSerializer.deserialize(IOStreamUtils.readInputStreamToString((ServletRequest)httpServletRequest)));
            IOStreamUtils.writeToOutputStream((byte[])this.expectationSerializer.serialize(expectations).getBytes(), (ServletResponse)httpServletResponse);
            httpServletResponse.setStatus(HttpStatusCode.OK_200.code());
        } else {
            this.mockResponse(httpServletRequest, httpServletResponse);
        }
    }

    private void mockResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpRequest httpRequest = this.httpServletToMockServerRequestMapper.mapHttpServletRequestToMockServerRequest(httpServletRequest);
        HttpResponse httpResponse = this.mockServerMatcher.handle(httpRequest);
        this.logFilter.onResponse(httpRequest, httpResponse);
        if (httpResponse != null) {
            this.mockServerToHttpServletResponseMapper.mapMockServerResponseToHttpServletResponse(httpResponse, httpServletResponse);
        } else {
            httpServletResponse.setStatus(HttpStatusCode.NOT_FOUND_404.code());
        }
    }
}

