/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.server;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.filters.LogFilter;
import org.mockserver.mappers.HttpServletToMockServerRequestMapper;
import org.mockserver.mappers.MockServerToHttpServletResponseMapper;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.streams.IOStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerServlet
extends HttpServlet {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MockServerMatcher mockServerMatcher = new MockServerMatcher();
    private LogFilter logFilter = new LogFilter();
    private ActionHandler actionHandler = new ActionHandler(this.logFilter);
    private HttpServletToMockServerRequestMapper httpServletToMockServerRequestMapper = new HttpServletToMockServerRequestMapper();
    private MockServerToHttpServletResponseMapper mockServerToHttpServletResponseMapper = new MockServerToHttpServletResponseMapper();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.mockResponse(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.mockResponse(httpServletRequest, httpServletResponse);
    }

    public void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            String requestPath = this.retrieveRequestPath(httpServletRequest);
            if (requestPath.equals("/status")) {
                httpServletResponse.setStatus(HttpStatusCode.OK_200.code());
            } else if (requestPath.equals("/expectation")) {
                Expectation expectation = this.expectationSerializer.deserialize(IOStreamUtils.readInputStreamToString((ServletRequest)httpServletRequest));
                this.mockServerMatcher.when(expectation.getHttpRequest(), expectation.getTimes()).thenRespond(expectation.getHttpResponse(false)).thenForward(expectation.getHttpForward()).thenCallback(expectation.getHttpCallback());
                httpServletResponse.setStatus(HttpStatusCode.CREATED_201.code());
            } else if (requestPath.equals("/clear")) {
                HttpRequest httpRequest = this.httpRequestSerializer.deserialize(IOStreamUtils.readInputStreamToString((ServletRequest)httpServletRequest));
                this.logFilter.clear(httpRequest);
                this.mockServerMatcher.clear(httpRequest);
                httpServletResponse.setStatus(HttpStatusCode.ACCEPTED_202.code());
            } else if (requestPath.equals("/reset")) {
                this.logFilter.reset();
                this.mockServerMatcher.reset();
                httpServletResponse.setStatus(HttpStatusCode.ACCEPTED_202.code());
            } else if (requestPath.equals("/dumpToLog")) {
                this.mockServerMatcher.dumpToLog(this.httpRequestSerializer.deserialize(IOStreamUtils.readInputStreamToString((ServletRequest)httpServletRequest)));
                httpServletResponse.setStatus(HttpStatusCode.ACCEPTED_202.code());
            } else if (requestPath.equals("/retrieve")) {
                Expectation[] expectations = this.logFilter.retrieve(this.httpRequestSerializer.deserialize(IOStreamUtils.readInputStreamToString((ServletRequest)httpServletRequest)));
                httpServletResponse.setStatus(HttpStatusCode.OK_200.code());
                httpServletResponse.setHeader("Content-Type", "application/json; charset=utf-8");
                IOStreamUtils.writeToOutputStream((byte[])this.expectationSerializer.serialize(expectations).getBytes(), (ServletResponse)httpServletResponse);
            } else if (requestPath.equals("/verify")) {
                String result = this.logFilter.verify(this.verificationSerializer.deserialize(IOStreamUtils.readInputStreamToString((ServletRequest)httpServletRequest)));
                if (result.isEmpty()) {
                    httpServletResponse.setStatus(HttpStatusCode.ACCEPTED_202.code());
                } else {
                    httpServletResponse.setStatus(HttpStatusCode.NOT_ACCEPTABLE_406.code());
                    httpServletResponse.setHeader("Content-Type", "application/json; charset=utf-8");
                    IOStreamUtils.writeToOutputStream((byte[])result.getBytes(), (ServletResponse)httpServletResponse);
                }
            } else if (requestPath.equals("/verifySequence")) {
                String result = this.logFilter.verify(this.verificationSequenceSerializer.deserialize(IOStreamUtils.readInputStreamToString((ServletRequest)httpServletRequest)));
                if (result.isEmpty()) {
                    httpServletResponse.setStatus(HttpStatusCode.ACCEPTED_202.code());
                } else {
                    httpServletResponse.setStatus(HttpStatusCode.NOT_ACCEPTABLE_406.code());
                    httpServletResponse.setHeader("Content-Type", "application/json; charset=utf-8");
                    IOStreamUtils.writeToOutputStream((byte[])result.getBytes(), (ServletResponse)httpServletResponse);
                }
            } else if (requestPath.equals("/stop")) {
                httpServletResponse.setStatus(HttpStatusCode.NOT_IMPLEMENTED_501.code());
            } else {
                this.mockResponse(httpServletRequest, httpServletResponse);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception processing " + httpServletRequest, (Throwable)e);
            httpServletResponse.setStatus(HttpStatusCode.BAD_REQUEST_400.code());
        }
    }

    private String retrieveRequestPath(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getPathInfo() != null && httpServletRequest.getContextPath() != null ? httpServletRequest.getPathInfo() : httpServletRequest.getRequestURI();
    }

    private void mockResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpRequest httpRequest = this.httpServletToMockServerRequestMapper.mapHttpServletRequestToMockServerRequest(httpServletRequest);
        HttpResponse httpResponse = this.actionHandler.processAction(this.mockServerMatcher.handle(httpRequest), httpRequest);
        this.mapResponse(httpResponse, httpServletResponse);
    }

    private void mapResponse(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse != null) {
            this.mockServerToHttpServletResponseMapper.mapMockServerResponseToHttpServletResponse(httpResponse, httpServletResponse);
        } else {
            httpServletResponse.setStatus(HttpStatusCode.NOT_FOUND_404.code());
        }
    }
}

