/*
 * Decompiled with CFR 0.152.
 */
package org.mockito;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.stream.Stream;
import org.mockito.Mockito;

class MockitoEnhancerUtil {
    MockitoEnhancerUtil() {
    }

    static <T> T stubMock(T t) {
        Stream.of(t.getClass().getMethods()).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> method.getName().contains("$default$")).forEach(method -> Mockito.when(MockitoEnhancerUtil.call(method, t, new Object[0])).thenCallRealMethod());
        return t;
    }

    private static <T> T call(Method method, Object object, Object ... objectArray) {
        try {
            return (T)method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            String string = MessageFormat.format("Calling {0} on {1} with args {2}", method, object, Arrays.toString(objectArray));
            throw new RuntimeException(string, exception);
        }
    }
}

