/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mockito.ArgumentExtractor;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.matchers.ArrayEquals;
import org.mockito.internal.matchers.Equals;

public class ArgumentsProcessor {
    public static Map<Class<?>, ArgumentExtractor> extractors = new ConcurrentHashMap();

    public static Object[] expandArgs(MockitoMethod mockitoMethod, Object[] objectArray) {
        int n = mockitoMethod.getParameterTypes().length;
        if (objectArray != null && objectArray.length > n) {
            objectArray = Arrays.copyOf(objectArray, n);
        }
        return ArgumentsProcessor.expandVarArgs(mockitoMethod.isVarArgs(), ArgumentsProcessor.unwrapByNameArgs(mockitoMethod, objectArray));
    }

    private static Object[] unwrapByNameArgs(MockitoMethod mockitoMethod, Object[] objectArray) {
        Class<?> clazz = mockitoMethod.getJavaMethod().getDeclaringClass();
        if (extractors.containsKey(clazz)) {
            return extractors.get(clazz).transformArgs(mockitoMethod.getName(), objectArray);
        }
        return objectArray;
    }

    private static Object[] expandVarArgs(boolean bl, Object[] objectArray) {
        if (!bl || ArgumentsProcessor.isNullOrEmpty(objectArray) || objectArray[objectArray.length - 1] != null && !objectArray[objectArray.length - 1].getClass().isArray()) {
            return objectArray == null ? new Object[]{} : objectArray;
        }
        int n = objectArray.length - 1;
        Object[] objectArray2 = objectArray[n] == null ? new Object[]{null} : ArrayEquals.createObjectArray((Object)objectArray[n]);
        int n2 = objectArray2.length;
        Object[] objectArray3 = new Object[n + n2];
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        System.arraycopy(objectArray2, 0, objectArray3, n, n2);
        return objectArray3;
    }

    private static <T> boolean isNullOrEmpty(T[] TArray) {
        return TArray == null || TArray.length == 0;
    }

    public static List<ArgumentMatcher> argumentsToMatchers(Object[] objectArray) {
        ArrayList<ArgumentMatcher> arrayList = new ArrayList<ArgumentMatcher>(objectArray.length);
        for (Object object : objectArray) {
            if (object != null && object.getClass().isArray()) {
                arrayList.add((ArgumentMatcher)new ArrayEquals(object));
                continue;
            }
            arrayList.add((ArgumentMatcher)new Equals(object));
        }
        return arrayList;
    }
}

