/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.gettingstarted;

import org.modelmapper.ModelMapper;
import org.modelmapper.PropertyMap;
import org.modelmapper.gettingstarted.Address;
import org.modelmapper.gettingstarted.Customer;
import org.modelmapper.gettingstarted.Name;
import org.modelmapper.gettingstarted.Order;
import org.modelmapper.gettingstarted.OrderDTO;
import org.testng.Assert;

public class GettingStartedExample {
    public static void main(String ... args) throws Exception {
        GettingStartedExample.mapAutomatically();
        GettingStartedExample.mapExplicitly();
    }

    static void mapAutomatically() {
        Order order = GettingStartedExample.createOrder();
        ModelMapper modelMapper = new ModelMapper();
        OrderDTO orderDTO = (OrderDTO)modelMapper.map((Object)order, OrderDTO.class);
        GettingStartedExample.assertOrdersEqual(order, orderDTO);
    }

    static void mapExplicitly() {
        Order order = GettingStartedExample.createOrder();
        ModelMapper modelMapper = new ModelMapper();
        modelMapper.addMappings((PropertyMap)new PropertyMap<Order, OrderDTO>(){

            protected void configure() {
                ((OrderDTO)this.map()).setBillingStreet(((Order)this.source).getBillingAddress().getStreet());
                this.map(((Order)this.source).billingAddress.getCity(), ((OrderDTO)this.destination).billingCity);
            }
        });
        OrderDTO orderDTO = (OrderDTO)modelMapper.map((Object)order, OrderDTO.class);
        GettingStartedExample.assertOrdersEqual(order, orderDTO);
    }

    static Order createOrder() {
        Customer customer = new Customer(new Name("Joe", "Smith"));
        Address billingAddress = new Address("2233 Pike Street", "Seattle");
        return new Order(customer, billingAddress);
    }

    static void assertOrdersEqual(Order order, OrderDTO orderDTO) {
        Assert.assertEquals((String)orderDTO.getCustomerFirstName(), (String)order.getCustomer().getName().getFirstName());
        Assert.assertEquals((String)orderDTO.getCustomerLastName(), (String)order.getCustomer().getName().getLastName());
        Assert.assertEquals((String)orderDTO.getBillingStreet(), (String)order.getBillingAddress().getStreet());
        Assert.assertEquals((String)orderDTO.getBillingCity(), (String)order.getBillingAddress().getCity());
    }
}

