/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import org.modeshape.common.annotation.NotThreadSafe;

@NotThreadSafe
public class DdlParserScorer {
    private int score = 0;

    public void reset() {
        this.score = 0;
    }

    public void scoreStatements(int count) {
        this.score += count;
    }

    public void scoreText(String text, int factor, String ... keywords) {
        if (text != null && keywords != null) {
            String lowercaseText = text.toLowerCase();
            for (String keyword : keywords) {
                if (keyword == null) continue;
                String lowercaseKeyword = keyword.toLowerCase();
                int index = 0;
                while ((index = lowercaseText.indexOf(lowercaseKeyword, index)) != -1) {
                    this.score += factor;
                    ++index;
                }
            }
        }
    }

    public void scoreText(String text, String ... keywords) {
        this.scoreText(text, 1, keywords);
    }

    public int getScore() {
        return this.score;
    }

    public String toString() {
        return Integer.toString(this.score);
    }
}

