/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.text.TokenStream;

public class DdlTokenStream
extends TokenStream {
    protected List<String[]> registeredStatementStartPhrases = new ArrayList<String[]>();
    protected Set<String> registeredKeyWords = new HashSet<String>();
    private Position currentMarkedPosition = Position.EMPTY_CONTENT_POSITION;

    protected List<TokenStream.Token> initializeTokens(List<TokenStream.Token> tokens) {
        TokenStream.Token[] tokensArray = tokens.toArray(new TokenStream.Token[tokens.size()]);
        ArrayList<TokenStream.Token> reTypedTokens = new ArrayList<TokenStream.Token>(tokens.size());
        for (int i = 0; i < tokensArray.length; ++i) {
            boolean isStatementStart = false;
            if (this.isKeyWord(tokensArray[i].value())) {
                TokenStream.Token retypedToken = tokensArray[i].withType(64);
                int tokenIncrement = 0;
                for (String[] nextStmtStart : this.registeredStatementStartPhrases) {
                    boolean matches = true;
                    for (int j = 0; j < nextStmtStart.length; ++j) {
                        if (!matches) continue;
                        matches = nextStmtStart[j].equalsIgnoreCase(tokensArray[i + j].value()) || nextStmtStart[j].equals("any value");
                    }
                    if (!matches) continue;
                    isStatementStart = true;
                    tokenIncrement = nextStmtStart.length - 1;
                    break;
                }
                if (isStatementStart) {
                    retypedToken = retypedToken.withType(128);
                }
                reTypedTokens.add(retypedToken);
                if (!isStatementStart) continue;
                for (int k = 0; k < tokenIncrement; ++k) {
                    reTypedTokens.add(tokensArray[++i]);
                }
                continue;
            }
            reTypedTokens.add(tokensArray[i]);
        }
        return reTypedTokens;
    }

    public DdlTokenStream(String content, TokenStream.Tokenizer tokenizer, boolean caseSensitive) {
        super(content, tokenizer, caseSensitive);
    }

    public void registerStatementStartPhrase(String[] phrase) {
        this.registeredStatementStartPhrases.add(phrase);
    }

    public void registerStatementStartPhrase(String[][] phrases) {
        for (String[] phrase : phrases) {
            this.registeredStatementStartPhrases.add(phrase);
        }
    }

    public void registerKeyWord(String keyWord) {
        this.registeredKeyWords.add(keyWord);
    }

    public void registerKeyWords(List<String> keyWords) {
        this.registeredKeyWords.addAll(keyWords);
    }

    public void registerKeyWords(String[] keyWords) {
        this.registeredKeyWords.addAll(Arrays.asList(keyWords));
    }

    protected boolean isKeyWord(String word) {
        return this.registeredKeyWords.contains(word.toUpperCase());
    }

    public boolean isNextKeyWord() {
        return this.matches(64);
    }

    public int computeNextStatementStartKeywordCount() {
        int result = 0;
        if (this.isNextKeyWord()) {
            for (String[] nextStmtStart : this.registeredStatementStartPhrases) {
                if (!this.matches(nextStmtStart)) continue;
                return nextStmtStart.length;
            }
        }
        return result;
    }

    public void mark() {
        this.currentMarkedPosition = this.hasNext() ? this.nextPosition() : null;
    }

    public String getMarkedContent() {
        Position startPosition = new Position(this.currentMarkedPosition.getIndexInContent(), this.currentMarkedPosition.getLine(), this.currentMarkedPosition.getColumn());
        this.mark();
        return this.getContentBetween(startPosition, this.currentMarkedPosition);
    }

    public static DdlTokenizer ddlTokenizer(boolean includeComments) {
        return new DdlTokenizer(includeComments);
    }

    public static class DdlTokenizer
    implements TokenStream.Tokenizer {
        public static final String PARSER_ID = "PARSER_ID";
        public static final int WORD = 1;
        public static final int SYMBOL = 2;
        public static final int DECIMAL = 4;
        public static final int SINGLE_QUOTED_STRING = 8;
        public static final int DOUBLE_QUOTED_STRING = 16;
        public static final int COMMENT = 32;
        private final boolean useComments;
        public static final int KEYWORD = 64;
        public static final int STATEMENT_KEY = 128;

        public DdlTokenizer(boolean useComments) {
            this.useComments = useComments;
        }

        public boolean includeComments() {
            return this.useComments;
        }

        public void tokenize(TokenStream.CharacterStream input, TokenStream.Tokens tokens) throws ParsingException {
            block9: while (input.hasNext()) {
                char c = input.next();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    case '-': {
                        int endIndex;
                        int startIndex = input.index();
                        Position startPosition = input.position(startIndex);
                        if (input.isNext('-')) {
                            boolean foundLineTerminator = false;
                            while (input.hasNext()) {
                                c = input.next();
                                if (c != '\n' && c != '\r') continue;
                                foundLineTerminator = true;
                                break;
                            }
                            endIndex = input.index();
                            if (!foundLineTerminator) {
                                ++endIndex;
                            }
                            if (c == '\r' && input.isNext('\n')) {
                                input.next();
                            }
                            if (!this.useComments) continue block9;
                            tokens.addToken(startPosition, startIndex, endIndex, 32);
                            break;
                        }
                        tokens.addToken(startPosition, startIndex, startIndex + 1, 2);
                        break;
                    }
                    case '!': 
                    case '$': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case ':': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '|': 
                    case '}': {
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                        break;
                    }
                    case '.': {
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 4);
                        break;
                    }
                    case '\"': {
                        int startIndex = input.index();
                        Position startingPosition = input.position(startIndex);
                        boolean foundClosingQuote = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c == '\\' && input.isNext('\"')) {
                                c = input.next();
                                continue;
                            }
                            if (c != '\"') continue;
                            foundClosingQuote = true;
                            break;
                        }
                        if (!foundClosingQuote) {
                            String msg = CommonI18n.noMatchingDoubleQuoteFound.text(new Object[]{startingPosition.getLine(), startingPosition.getColumn()});
                            throw new ParsingException(startingPosition, msg);
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(startingPosition, startIndex, endIndex, 16);
                        break;
                    }
                    case '\'': 
                    case '\u2019': {
                        char quoteChar = c;
                        int startIndex = input.index();
                        Position startingPosition = input.position(startIndex);
                        boolean foundClosingQuote = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c == '\\' && input.isNext(quoteChar)) {
                                c = input.next();
                                continue;
                            }
                            if (c != quoteChar) continue;
                            foundClosingQuote = true;
                            break;
                        }
                        if (!foundClosingQuote) {
                            String msg = CommonI18n.noMatchingSingleQuoteFound.text(new Object[]{startingPosition.getLine(), startingPosition.getColumn()});
                            throw new ParsingException(startingPosition, msg);
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(startingPosition, startIndex, endIndex, 8);
                        break;
                    }
                    case '/': {
                        int endIndex;
                        int startIndex = input.index();
                        Position startingPosition = input.position(startIndex);
                        if (input.isNext('/')) {
                            boolean foundLineTerminator = false;
                            while (input.hasNext()) {
                                c = input.next();
                                if (c != '\n' && c != '\r') continue;
                                foundLineTerminator = true;
                                break;
                            }
                            endIndex = input.index();
                            if (!foundLineTerminator) {
                                ++endIndex;
                            }
                            if (c == '\r' && input.isNext('\n')) {
                                input.next();
                            }
                            if (!this.useComments) continue block9;
                            tokens.addToken(startingPosition, startIndex, endIndex, 32);
                            break;
                        }
                        if (input.isNext('*')) {
                            while (input.hasNext() && !input.isNext('*', '/')) {
                                c = input.next();
                            }
                            if (input.hasNext()) {
                                input.next();
                            }
                            if (input.hasNext()) {
                                input.next();
                            }
                            endIndex = input.index() + 1;
                            if (!this.useComments) continue block9;
                            tokens.addToken(startingPosition, startIndex, endIndex, 32);
                            break;
                        }
                        tokens.addToken(startingPosition, startIndex, startIndex + 1, 2);
                        break;
                    }
                    default: {
                        int startIndex = input.index();
                        Position startPosition = input.position(startIndex);
                        while (input.hasNext() && !input.isNextWhitespace() && !input.isNextAnyOf("/.-(){}*,;+%?$[]!<>|=:")) {
                            c = input.next();
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(startPosition, startIndex, endIndex, 1);
                    }
                }
            }
        }
    }
}

