/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xsd;

import javax.jcr.Node;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class XsdSequencerTest
extends AbstractSequencerTest {
    @Test
    public void shouldBeAbleToParseXsdForStockQuote() throws Exception {
        this.assertSequencedSuccessfully("stockQuote.xsd");
    }

    private Node assertSequencedSuccessfully(String filename) throws Exception {
        int pathSeparatorIndex = filename.lastIndexOf("/");
        String nodeName = pathSeparatorIndex != -1 ? filename.substring(pathSeparatorIndex + 1) : filename;
        this.createNodeWithContentFromFile(nodeName, filename);
        Node outputNode = this.getOutputNode(this.rootNode, nodeName + "/" + "xs:schemaDocument");
        Assert.assertNotNull((Object)outputNode);
        this.assertCreatedBySessionUser(outputNode, (Session)this.session);
        Assert.assertEquals((Object)"xs:schemaDocument", (Object)outputNode.getPrimaryNodeType().getName());
        Assert.assertTrue((outputNode.getNodes().getSize() > 0L ? 1 : 0) != 0);
        return outputNode;
    }

    @Test
    public void shouldBeAbleToParseXsdForUddiV3() throws Exception {
        this.assertSequencedSuccessfully("uddi_v3.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter01() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter01.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter03env() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter03env.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter03ord() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter03ord.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter03prod() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter03prod.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter03prod2() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter03prod2.xsd");
    }

    @Test
    @FixFor(value={"MODE-2183"})
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter04ord1() throws Exception {
        Node outputNode = this.assertSequencedSuccessfully("definitiveXmlSchema/chapter04ord1.xsd");
        Node includeNode = outputNode.getNode("xs:include");
        Assert.assertThat((Object)includeNode.hasProperty("xs:schemaLocation"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)includeNode.hasProperty("schemaLocation"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter04ord2() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter04ord2.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter04prod() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter04prod.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter05ord() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter05ord.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter05prod() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter05prod.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter07() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter07.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter08() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter08.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter09() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter09.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter11() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter11.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter13() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter13.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter14() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter14.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter15() throws Exception {
        this.assertSequencedSuccessfully("definitiveXmlSchema/chapter15.xsd");
    }

    @Test
    @FixFor(value={"MODE-1464", "MODE-2183"})
    public void shouldBeAbleToParseUnsignedLong() throws Exception {
        Node outputNode = this.assertSequencedSuccessfully("unsigned_long.xsd");
        Node includeNode = outputNode.getNode("xs:import");
        Assert.assertThat((Object)includeNode.hasProperty("xs:schemaLocation"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)includeNode.hasProperty("schemaLocation"), (Matcher)Is.is((Object)false));
        Node complexType = outputNode.getNode("openAttrs");
        Assert.assertThat((Object)complexType.hasProperty("xs:mixed"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)complexType.hasProperty("mixed"), (Matcher)Is.is((Object)false));
    }
}

