/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.fromcatalina;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLHelper {
    public static Node findSubElement(Node parent, String localName) {
        if (parent == null) {
            return null;
        }
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getLocalName().equals(localName)) continue;
            return child;
        }
        return null;
    }

    public static Vector<String> getPropertiesFromXML(Node propNode) {
        Vector<String> properties = new Vector<String>();
        NodeList childList = propNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node currentNode = childList.item(i);
            if (currentNode.getNodeType() != 1) continue;
            String nodeName = currentNode.getLocalName();
            String namespace = currentNode.getNamespaceURI();
            properties.addElement(namespace + ":" + nodeName);
        }
        return properties;
    }

    public static Map<String, Object> getPropertiesWithValuesFromXML(Node propNode) {
        HashMap<String, Object> propertiesWithValues = new HashMap<String, Object>();
        NodeList childList = propNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node currentNode = childList.item(i);
            if (currentNode.getNodeType() != 1) continue;
            String nodeName = currentNode.getLocalName();
            String namespace = currentNode.getNamespaceURI();
            String fqn = namespace + ":" + nodeName;
            propertiesWithValues.put(fqn, XMLHelper.nodeValue(currentNode));
        }
        return propertiesWithValues;
    }

    private static Object nodeValue(Node node) {
        NodeList childList = node.getChildNodes();
        if (childList.getLength() == 0) {
            return "";
        }
        if (childList.getLength() == 1 && childList.item(0).getNodeType() == 3) {
            return node.getTextContent().trim();
        }
        ArrayList<Object> value = new ArrayList<Object>();
        for (int i = 0; i < childList.getLength(); ++i) {
            value.add(XMLHelper.nodeValue(childList.item(i)));
        }
        return value;
    }
}

