/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.apps.model;

import java.util.Objects;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.system.core.FreemarkerTemplateMetaData;
import org.molgenis.file.model.FileMetaMetaData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppMetaData
extends SystemEntityType {
    private static final String SIMPLE_NAME = "App";
    public static final String APP = "sys_App";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String ICON_HREF = "iconHref";
    public static final String IS_ACTIVE = "isActive";
    public static final String LANDING_PAGE_HTML_TEMPLATE = "landingPageHtmlTemplate";
    public static final String RESOURCE_ZIP = "resourceZip";
    private final FileMetaMetaData fileMetaMetaData;
    private final FreemarkerTemplateMetaData freemarkerTemplateMetaData;

    @Autowired
    public AppMetaData(FileMetaMetaData fileMetaMetaData, FreemarkerTemplateMetaData freemarkerTemplateMetaData) {
        super(SIMPLE_NAME, "sys");
        this.fileMetaMetaData = Objects.requireNonNull(fileMetaMetaData);
        this.freemarkerTemplateMetaData = Objects.requireNonNull(freemarkerTemplateMetaData);
    }

    protected void init() {
        this.setLabel(SIMPLE_NAME);
        this.addAttribute(ID, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setAuto(true).setLabel("Id");
        this.addAttribute(NAME, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LABEL, EntityType.AttributeRole.ROLE_LOOKUP}).setLabel("Name").setNillable(false).setUnique(true);
        this.addAttribute(DESCRIPTION, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LOOKUP}).setDataType(AttributeType.TEXT).setNillable(true).setLabel("Description");
        this.addAttribute(ICON_HREF, new EntityType.AttributeRole[0]).setDataType(AttributeType.HYPERLINK).setNillable(true).setLabel("Icon URL").setDescription("Absolute or relative URL of the app icon");
        this.addAttribute(RESOURCE_ZIP, new EntityType.AttributeRole[0]).setDataType(AttributeType.FILE).setRefEntity((EntityType)this.fileMetaMetaData).setNillable(true).setLabel("Resource ZIP file").setDescription("ZIP file with JavaScript, CSS and image files required by the app");
        this.addAttribute(IS_ACTIVE, new EntityType.AttributeRole[0]).setDataType(AttributeType.BOOL).setLabel("Active").setNillable(false).setVisible(false).setDefaultValue(Boolean.FALSE.toString());
        this.addAttribute(LANDING_PAGE_HTML_TEMPLATE, new EntityType.AttributeRole[0]).setDataType(AttributeType.XREF).setRefEntity((EntityType)this.freemarkerTemplateMetaData).setNillable(false).setLabel("Landing page HTML template").setDescription("Landing page HTML FreeMarker template");
    }
}

