/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model.elements;

import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Record;
import org.molgenis.model.elements.UISchema;

public class Plugin
extends UISchema {
    private Record record;
    private Entity entity = null;
    private String pluginType;
    private boolean readonly;
    private Flavor flavor = Flavor.FREEMARKER;
    private static final long serialVersionUID = -2642011592737487306L;

    public Plugin(String name, UISchema parent, String pluginType) {
        super(name, parent);
        this.pluginType = pluginType;
    }

    @Override
    public UISchema.Type getType() {
        return UISchema.Type.PLUGIN;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setRecord(Record record) {
        this.record = record;
    }

    public Record getRecord() {
        return this.record;
    }

    public void setReadOnly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public String toString() {
        if (this.getRecord() != null) {
            return String.format("Plugin(name=%s, entity=%s, group=%s)", this.getName(), this.getRecord().getName(), this.getGroup());
        }
        return String.format("Plugin(name=%s, group=%s)", this.getName(), this.getGroup());
    }

    public boolean getReadOnly() {
        return this.readonly;
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(String pluginType) {
        this.pluginType = pluginType;
    }

    public Flavor getFlavor() {
        return this.flavor;
    }

    public void setPluginMethod(Flavor pluginMethod) {
        this.flavor = pluginMethod;
    }

    public static enum Flavor {
        FREEMARKER("freemarker"),
        EASY("easy"),
        UNKNOWN("unknown");

        private String tag;

        private Flavor(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return this.tag;
        }

        public static Flavor getPluginMethod(String method) throws MolgenisModelException {
            StringBuilder optionsBuilder = new StringBuilder();
            for (Flavor p : Flavor.values()) {
                if (p.toString().equalsIgnoreCase(method)) {
                    return p;
                }
                optionsBuilder.append(p.toString()).append(", ");
            }
            throw new MolgenisModelException("method='" + method + "' is UNKNOWN for plugin. Valid options: " + optionsBuilder.toString());
        }
    }
}

