/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model.elements;

import java.util.List;
import java.util.Vector;
import org.molgenis.fieldtypes.XrefField;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.DBSchema;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Field;
import org.molgenis.model.elements.Record;

public class View
extends DBSchema
implements Record {
    String label = "";
    String description = "";
    public Vector<String> entities = new Vector();
    private static final long serialVersionUID = 0L;

    public View(String name, String label, DBSchema parent) {
        super(name, parent, parent.getModel());
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Field> getAllFields() throws MolgenisModelException {
        return this.getFields();
    }

    @Override
    public List<Field> getFields() throws MolgenisModelException {
        DBSchema database = (DBSchema)this.getRoot();
        Vector<Field> fields = new Vector<Field>();
        for (String viewentity : this.entities) {
            Entity entity = (Entity)database.get(viewentity);
            for (Field field : entity.getAllFields()) {
                Field f = new Field(field);
                f.setUserData(field.getName());
                f.setName(entity.getName() + "_" + field.getName());
                f.setLabel(entity.getName() + "::" + field.getName());
                fields.add(f);
            }
        }
        return fields;
    }

    @Override
    public boolean hasXRefs() {
        DBSchema database = (DBSchema)this.getRoot();
        for (String viewentity : this.entities) {
            if (!((Entity)database.get(viewentity)).hasXRefs()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector<String> getParents() {
        return new Vector<String>();
    }

    public void addEntity(String entity) {
        if (!this.entities.contains(entity)) {
            this.entities.add(entity);
        }
    }

    public List<String> getEntities() {
        return this.entities;
    }

    public int getNrEntities() {
        return this.entities.size();
    }

    public List<Field> getXRefsFor(Entity e, List<Entity> entities) throws MolgenisModelException {
        Vector<Field> xrefs = new Vector<Field>();
        for (Entity entity : entities) {
            for (Field field : e.getAllFields()) {
                if (!(field.getType() instanceof XrefField)) continue;
                try {
                    if (!field.getXrefEntity().getName().equals(entity.getName())) continue;
                    xrefs.add(field);
                }
                catch (Exception ex) {}
            }
            for (Field field : entity.getAllFields()) {
                if (!(field.getType() instanceof XrefField)) continue;
                try {
                    if (!field.getXrefEntity().getName().equals(e.getName())) continue;
                    xrefs.add(field);
                }
                catch (Exception ex) {}
            }
        }
        return xrefs;
    }
}

