/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model.jaxb;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.molgenis.model.jaxb.Entity;
import org.molgenis.model.jaxb.Module;
import org.molgenis.model.jaxb.Screen;

@XmlRootElement(name="molgenis")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Model {
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String label;
    @XmlAttribute
    private String version;
    @XmlElement(name="entity")
    private List<Entity> entities = new ArrayList<Entity>();
    @XmlElement(name="module")
    private List<Module> modules = new ArrayList<Module>();
    @XmlElement
    private List<Screen> screens = new ArrayList<Screen>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void addEntity(Entity e) {
        this.entities.add(e);
    }

    public void addModule(Module e) {
        this.modules.add(e);
    }

    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    public Entity getEntity(String name) {
        for (Entity entity : this.entities) {
            if (!entity.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return entity;
        }
        return null;
    }

    public String findModuleNameForEntity(String name) {
        for (Module module : this.modules) {
            for (Entity entity : module.getEntities()) {
                if (!entity.getName().equalsIgnoreCase(name)) continue;
                return module.getName();
            }
        }
        return null;
    }

    public Entity findEntity(String name) {
        for (Entity entity : this.entities) {
            if (!entity.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return entity;
        }
        for (Module module : this.modules) {
            for (Entity entity : module.getEntities()) {
                if (!entity.getName().toLowerCase().equals(name.toLowerCase())) continue;
                return entity;
            }
        }
        return null;
    }

    public Module getModule(String name) {
        for (Module module : this.modules) {
            if (!module.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return module;
        }
        return null;
    }

    public Integer removeModule(String name) {
        for (int i = 0; i < this.modules.size(); ++i) {
            if (!this.modules.get(i).getName().toLowerCase().equals(name.toLowerCase())) continue;
            this.modules.remove(i);
            if (this.modules.size() > 0) {
                return i == 0 ? 0 : i - 1;
            }
            return null;
        }
        return null;
    }

    public synchronized List<Screen> getScreens() {
        return this.screens;
    }

    public synchronized void setScreens(List<Screen> screens) {
        this.screens = screens;
    }

    public synchronized List<Module> getModules() {
        return this.modules;
    }

    public synchronized void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public String findRemoveEntity(String name) {
        for (int i = 0; i < this.entities.size(); ++i) {
            if (!this.entities.get(i).getName().toLowerCase().equals(name.toLowerCase())) continue;
            this.entities.remove(i);
            if (this.entities.size() > 0) {
                if (i == 0) {
                    return this.entities.get(0).getName();
                }
                return this.entities.get(i - 1).getName();
            }
            return null;
        }
        for (Module module : this.modules) {
            for (int i = 0; i < module.getEntities().size(); ++i) {
                if (!module.getEntities().get(i).getName().toLowerCase().equals(name.toLowerCase())) continue;
                module.getEntities().remove(i);
                if (module.getEntities().size() > 0) {
                    if (i == 0) {
                        return module.getEntities().get(0).getName();
                    }
                    return module.getEntities().get(i - 1).getName();
                }
                return null;
            }
        }
        return null;
    }
}

