/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import org.molgenis.gson.AutoValueTypeAdapterFactory;
import org.molgenis.util.GsonFactoryBean;
import org.molgenis.util.GsonHttpMessageConverter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GsonConfig {
    @Value(value="${environment:production}")
    private String environment;

    @Bean
    public GsonHttpMessageConverter gsonHttpMessageConverter() {
        return new GsonHttpMessageConverter(this.gsonFactoryBean().getObject());
    }

    @Bean
    public GsonFactoryBean gsonFactoryBean() {
        boolean prettyPrinting = this.environment != null && (this.environment.equals("development") || this.environment.equals("test"));
        GsonFactoryBean gsonFactoryBean = new GsonFactoryBean();
        gsonFactoryBean.setDateFormatPattern("yyyy-MM-dd'T'HH:mm:ssZ");
        gsonFactoryBean.setDisableHtmlEscaping(true);
        gsonFactoryBean.setPrettyPrinting(prettyPrinting);
        gsonFactoryBean.setSerializeNulls(false);
        gsonFactoryBean.registerTypeAdapterFactory(new AutoValueTypeAdapterFactory());
        return gsonFactoryBean;
    }
}

