/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.UnknownEntityTypeException;
import org.molgenis.data.csv.CsvFileExtensions;
import org.molgenis.data.file.processor.AbstractCellProcessor;
import org.molgenis.data.file.processor.CellProcessor;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.util.CloseableIterator;
import org.springframework.util.StringUtils;

public class CsvIterator
implements CloseableIterator<Entity> {
    private final String repositoryName;
    private final EntityType entityType;
    private ZipFile zipFile;
    private CSVReader csvReader;
    private final List<CellProcessor> cellProcessors;
    private final Map<String, Integer> colNamesMap;
    private Entity next;
    private boolean getNext = true;
    private Character separator = null;

    CsvIterator(File file, String repositoryName, List<CellProcessor> cellProcessors, Character separator) {
        this(file, repositoryName, cellProcessors, separator, null);
    }

    CsvIterator(File file, String repositoryName, List<CellProcessor> cellProcessors, Character separator, EntityType entityType) {
        this.repositoryName = repositoryName;
        this.cellProcessors = cellProcessors;
        this.separator = separator;
        this.entityType = entityType;
        try {
            if (StringUtils.getFilenameExtension((String)file.getName()).equalsIgnoreCase("zip")) {
                this.zipFile = new ZipFile(file.getAbsolutePath());
                Enumeration<? extends ZipEntry> e = this.zipFile.entries();
                while (e.hasMoreElements()) {
                    String fileRepositoryName;
                    ZipEntry entry = e.nextElement();
                    if (entry.getName().contains("__MACOSX") || entry.isDirectory() || !(fileRepositoryName = FilenameUtils.getBaseName((String)entry.getName())).equalsIgnoreCase(repositoryName)) continue;
                    this.csvReader = this.createCSVReader(entry.getName(), this.removeByteOrderMark(this.zipFile.getInputStream(entry)));
                    break;
                }
            } else if (file.getName().toLowerCase().startsWith(repositoryName.toLowerCase())) {
                this.csvReader = this.createCSVReader(file.getName(), this.removeByteOrderMark(new FileInputStream(file)));
            }
            if (this.csvReader == null) {
                throw new UnknownEntityTypeException(entityType.getId());
            }
            this.colNamesMap = this.toColNamesMap(this.csvReader.readNext());
        }
        catch (IOException e) {
            throw new MolgenisDataException(String.format("Exception reading [%s]", file.getAbsolutePath()), (Throwable)e);
        }
    }

    private InputStream removeByteOrderMark(InputStream inputStream) {
        return new BOMInputStream(inputStream, false);
    }

    Map<String, Integer> getColNamesMap() {
        return this.colNamesMap;
    }

    public boolean hasNext() {
        boolean next;
        boolean bl = next = this.get() != null;
        if (!next) {
            this.close();
        }
        return next;
    }

    public Entity next() {
        Entity entity = this.get();
        this.getNext = true;
        return entity;
    }

    private Entity get() {
        if (this.getNext) {
            try {
                String[] values = this.csvReader.readNext();
                if (values != null && values.length == this.colNamesMap.size()) {
                    List<String> valueList = Arrays.asList(values);
                    for (int i = 0; i < values.length; ++i) {
                        String value = values[i].isEmpty() ? null : values[i];
                        values[i] = this.processCell(value, false);
                    }
                    this.next = new DynamicEntity(this.entityType);
                    for (String name : this.colNamesMap.keySet()) {
                        this.next.set(name, (Object)valueList.get(this.colNamesMap.get(name)));
                    }
                } else {
                    if (values != null && (values.length > 1 || values.length == 1 && values[0].length() > 0) && values.length < this.colNamesMap.size()) {
                        throw new MolgenisDataException(String.format("Number of values (%d) doesn't match the number of headers (%d): [%s]", values.length, this.colNamesMap.size(), Arrays.stream(values).collect(Collectors.joining(","))));
                    }
                    this.next = null;
                }
                this.getNext = false;
            }
            catch (IOException e) {
                throw new MolgenisDataException(String.format("Exception reading line of csv file [%s]", this.repositoryName), (Throwable)e);
            }
        }
        return this.next;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.csvReader != null) {
            try {
                this.csvReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private CSVReader createCSVReader(String fileName, InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        if (null == this.separator) {
            if (fileName.toLowerCase().endsWith('.' + CsvFileExtensions.CSV.toString()) || fileName.toLowerCase().endsWith('.' + CsvFileExtensions.TXT.toString())) {
                return new CSVReader((Reader)reader);
            }
            if (fileName.toLowerCase().endsWith('.' + CsvFileExtensions.TSV.toString())) {
                return new CSVReader((Reader)reader, '\t');
            }
            throw new MolgenisDataException(String.format("Unknown file type: [%s] for csv repository", fileName));
        }
        return new CSVReader((Reader)reader, this.separator.charValue());
    }

    private Map<String, Integer> toColNamesMap(String[] headers) {
        if (headers == null || headers.length == 0) {
            return Collections.emptyMap();
        }
        int capacity = (int)((double)headers.length / 0.75) + 1;
        LinkedHashMap<String, Integer> columnIdx = new LinkedHashMap<String, Integer>(capacity);
        for (int i = 0; i < headers.length; ++i) {
            String header = this.processCell(headers[i], true);
            if (columnIdx.containsKey(header)) {
                throw new MolgenisDataException(String.format("Duplicate column header '%s' not allowed", header));
            }
            columnIdx.put(header, i);
        }
        return columnIdx;
    }

    private String processCell(String value, boolean isHeader) {
        return AbstractCellProcessor.processCell((String)value, (boolean)isHeader, this.cellProcessors);
    }
}

