/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.csv;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.molgenis.data.Entity;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.csv.CsvIterator;
import org.molgenis.data.file.processor.CellProcessor;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.AbstractRepository;
import org.springframework.util.StringUtils;

public class CsvRepository
extends AbstractRepository {
    private final File file;
    private final EntityTypeFactory entityTypeFactory;
    private final AttributeFactory attrMetaFactory;
    private final String sheetName;
    private List<CellProcessor> cellProcessors;
    private EntityType entityType;
    private Character separator = null;

    public CsvRepository(String file, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory) {
        this(new File(file), entityTypeFactory, attrMetaFactory, null);
    }

    public CsvRepository(File file, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory, @Nullable List<CellProcessor> cellProcessors, Character separator) {
        this(file, entityTypeFactory, attrMetaFactory, StringUtils.stripFilenameExtension((String)file.getName()), null);
        this.separator = separator;
    }

    public CsvRepository(File file, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory, @Nullable List<CellProcessor> cellProcessors) {
        this(file, entityTypeFactory, attrMetaFactory, StringUtils.stripFilenameExtension((String)file.getName()), null);
    }

    public CsvRepository(File file, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory, String sheetName, @Nullable List<CellProcessor> cellProcessors) {
        this.file = file;
        this.entityTypeFactory = Objects.requireNonNull(entityTypeFactory);
        this.attrMetaFactory = Objects.requireNonNull(attrMetaFactory);
        this.sheetName = sheetName;
        this.cellProcessors = cellProcessors;
    }

    public Iterator<Entity> iterator() {
        return new CsvIterator(this.file, this.sheetName, this.cellProcessors, this.separator, this.getEntityType());
    }

    public EntityType getEntityType() {
        if (this.entityType == null) {
            this.entityType = (EntityType)this.entityTypeFactory.create((Object)this.sheetName);
            for (String attrName : new CsvIterator(this.file, this.sheetName, null, this.separator).getColNamesMap().keySet()) {
                Attribute attr = this.attrMetaFactory.create().setName(attrName).setDataType(AttributeType.STRING);
                this.entityType.addAttribute(attr, new EntityType.AttributeRole[0]);
            }
        }
        return this.entityType;
    }

    public void addCellProcessor(CellProcessor cellProcessor) {
        if (this.cellProcessors == null) {
            this.cellProcessors = new ArrayList<CellProcessor>();
        }
        this.cellProcessors.add(cellProcessor);
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.emptySet();
    }

    public long count() {
        return Iterables.size((Iterable)((Object)this));
    }
}

