/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.csv;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.file.processor.AbstractCellProcessor;
import org.molgenis.data.file.processor.CellProcessor;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.support.AbstractWritable;
import org.molgenis.util.UnexpectedEnumException;

public class CsvWriter
extends AbstractWritable {
    public static final char DEFAULT_SEPARATOR = ',';
    private final CSVWriter csvWriter;
    private List<CellProcessor> cellProcessors;
    private List<String> cachedAttributeNames;

    public CsvWriter(Writer writer) {
        this(writer, ',');
    }

    public CsvWriter(Writer writer, List<String> attributeNames) throws IOException {
        this(writer);
        this.writeAttributeNames(attributeNames);
    }

    public CsvWriter(Writer writer, char separator) {
        this(writer, separator, false);
    }

    public CsvWriter(Writer writer, char separator, boolean noQuotes) {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null");
        }
        this.csvWriter = noQuotes ? new CSVWriter(writer, separator, '\u0000') : new CSVWriter(writer, separator);
    }

    public CsvWriter(OutputStream os) {
        this(new OutputStreamWriter(os, StandardCharsets.UTF_8));
    }

    public CsvWriter(OutputStream os, char separator) {
        this((Writer)new OutputStreamWriter(os, StandardCharsets.UTF_8), separator);
    }

    public CsvWriter(OutputStream os, char separator, boolean noQuotes) {
        this(new OutputStreamWriter(os, StandardCharsets.UTF_8), separator, noQuotes);
    }

    public CsvWriter(File file) throws FileNotFoundException {
        this((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), ',');
    }

    public CsvWriter(File file, char separator) throws FileNotFoundException {
        this((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), separator);
    }

    public void addCellProcessor(CellProcessor cellProcessor) {
        if (this.cellProcessors == null) {
            this.cellProcessors = new ArrayList<CellProcessor>();
        }
        this.cellProcessors.add(cellProcessor);
    }

    public void add(Entity entity) {
        if (this.cachedAttributeNames == null) {
            throw new MolgenisDataException("No attribute names defined call writeAttributeNames first");
        }
        int i = 0;
        String[] values = new String[this.cachedAttributeNames.size()];
        for (String colName : this.cachedAttributeNames) {
            values[i++] = this.toValue(entity.get(colName));
        }
        this.csvWriter.writeNext(values);
        if (this.csvWriter.checkError()) {
            throw new MolgenisDataException("An exception occured writing the csv file");
        }
    }

    public void writeAttributeNames(Iterable<String> attributeNames) throws IOException {
        this.writeAttributes(attributeNames, attributeNames);
    }

    public void writeAttributes(Iterable<Attribute> attributes) throws IOException {
        ArrayList attributeNames = Lists.newArrayList();
        ArrayList attributeLabels = Lists.newArrayList();
        for (Attribute attr : attributes) {
            attributeNames.add(attr.getName());
            if (attr.getLabel() != null) {
                attributeLabels.add(attr.getLabel());
                continue;
            }
            attributeLabels.add(attr.getName());
        }
        this.writeAttributes(attributeNames, attributeLabels);
    }

    public void writeAttributes(Iterable<String> attributeNames, Iterable<String> attributeLabels) throws IOException {
        if (this.cachedAttributeNames == null) {
            ArrayList<String> processedAttributeNames = new ArrayList<String>();
            for (String colName : attributeNames) {
                String processedColName = AbstractCellProcessor.processCell((String)colName, (boolean)true, this.cellProcessors);
                processedAttributeNames.add(processedColName);
            }
            this.cachedAttributeNames = processedAttributeNames;
            this.csvWriter.writeNext((String[])Iterables.toArray(attributeLabels, String.class));
            if (this.csvWriter.checkError()) {
                throw new IOException();
            }
        }
    }

    public void close() throws IOException {
        this.csvWriter.close();
    }

    private String toValue(Object obj) {
        String value;
        block9: {
            block10: {
                block11: {
                    block8: {
                        if (obj != null) break block8;
                        value = null;
                        break block9;
                    }
                    if (!(obj instanceof Entity)) break block10;
                    if (this.getEntityWriteMode() == null) break block11;
                    switch (this.getEntityWriteMode()) {
                        case ENTITY_IDS: {
                            value = ((Entity)obj).getIdValue().toString();
                            break block9;
                        }
                        case ENTITY_LABELS: {
                            Object labelValue = ((Entity)obj).getLabelValue();
                            value = labelValue != null ? labelValue.toString() : null;
                            break block9;
                        }
                        default: {
                            throw new UnexpectedEnumException((Enum)this.getEntityWriteMode());
                        }
                    }
                }
                Object labelValue = ((Entity)obj).getLabelValue();
                value = labelValue != null ? labelValue.toString() : null;
                break block9;
            }
            if (obj instanceof Iterable) {
                StringBuilder strBuilder = new StringBuilder();
                for (Object listItem : (Iterable)obj) {
                    if (strBuilder.length() > 0) {
                        strBuilder.append(',');
                    }
                    strBuilder.append(this.toValue(listItem));
                }
                value = strBuilder.toString();
            } else {
                value = obj.toString();
            }
        }
        return AbstractCellProcessor.processCell(value, (boolean)false, this.cellProcessors);
    }

    public void flush() {
        try {
            this.csvWriter.flush();
        }
        catch (IOException e) {
            throw new MolgenisDataException("Error flushing csvwriter", (Throwable)e);
        }
    }

    public void clearCache() {
    }
}

